/*
 * Decompiled with CFR 0.152.
 */
package scoverage.report;

import java.io.File;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Iterable$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.Null$;
import scala.xml.PrettyPrinter;
import scala.xml.Text;
import scala.xml.TopScope$;
import scala.xml.UnprefixedAttribute;
import scoverage.Coverage;
import scoverage.IOUtils$;
import scoverage.MeasuredClass;
import scoverage.MeasuredMethod;
import scoverage.MeasuredPackage;
import scoverage.Serializer$;
import scoverage.Statement;
import scoverage.report.BaseReportWriter;

@ScalaSignature(bytes="\u0006\u0001-4A!\u0001\u0002\u0001\u000f\t\u00112kY8wKJ\fw-\u001a-nY^\u0013\u0018\u000e^3s\u0015\t\u0019A!\u0001\u0004sKB|'\u000f\u001e\u0006\u0002\u000b\u0005I1oY8wKJ\fw-Z\u0002\u0001'\t\u0001\u0001\u0002\u0005\u0002\n\u00155\t!!\u0003\u0002\f\u0005\t\u0001\")Y:f%\u0016\u0004xN\u001d;Xe&$XM\u001d\u0005\t\u001b\u0001\u0011\t\u0011)A\u0005\u001d\u0005\t2o\\;sG\u0016$\u0015N]3di>\u0014\u0018.Z:\u0011\u0007=IBD\u0004\u0002\u0011-9\u0011\u0011\u0003F\u0007\u0002%)\u00111CB\u0001\u0007yI|w\u000e\u001e \n\u0003U\tQa]2bY\u0006L!a\u0006\r\u0002\u000fA\f7m[1hK*\tQ#\u0003\u0002\u001b7\t\u00191+Z9\u000b\u0005]A\u0002CA\u000f#\u001b\u0005q\"BA\u0010!\u0003\tIwNC\u0001\"\u0003\u0011Q\u0017M^1\n\u0005\rr\"\u0001\u0002$jY\u0016D\u0001\"\n\u0001\u0003\u0002\u0003\u0006I\u0001H\u0001\n_V$\b/\u001e;ESJD\u0001b\n\u0001\u0003\u0002\u0003\u0006I\u0001K\u0001\u0006I\u0016\u0014Wo\u001a\t\u0003S)j\u0011\u0001G\u0005\u0003Wa\u0011qAQ8pY\u0016\fg\u000eC\u0003.\u0001\u0011\u0005a&\u0001\u0004=S:LGO\u0010\u000b\u0005_A\n$\u0007\u0005\u0002\n\u0001!)Q\u0002\fa\u0001\u001d!)Q\u0005\fa\u00019!)q\u0005\fa\u0001Q!)Q\u0006\u0001C\u0001iQ!q&N\u001c9\u0011\u001514\u00071\u0001\u001d\u0003%\u0019x.\u001e:dK\u0012K'\u000fC\u0003&g\u0001\u0007A\u0004C\u0003(g\u0001\u0007\u0001\u0006C\u0003;\u0001\u0011\u00051(A\u0003xe&$X\r\u0006\u0002=\u007fA\u0011\u0011&P\u0005\u0003}a\u0011A!\u00168ji\")\u0001)\u000fa\u0001\u0003\u0006A1m\u001c<fe\u0006<W\r\u0005\u0002C\u00076\tA!\u0003\u0002E\t\tA1i\u001c<fe\u0006<W\rC\u0003G\u0001\u0011%q)A\u0002y[2$\"\u0001S'\u0011\u0005%[U\"\u0001&\u000b\u0005\u0019C\u0012B\u0001'K\u0005\u0011qu\u000eZ3\t\u000b\u0001+\u0005\u0019A!\t\u000b=\u0003A\u0011\u0002)\u0002\u0013M$\u0018\r^3nK:$HC\u0001%R\u0011\u0015\u0011f\n1\u0001T\u0003\u0011\u0019H/\u001c;\u0011\u0005\t#\u0016BA+\u0005\u0005%\u0019F/\u0019;f[\u0016tG\u000fC\u0003X\u0001\u0011%\u0001,\u0001\u0004nKRDw\u000e\u001a\u000b\u0003\u0011fCQa\u0016,A\u0002i\u0003\"AQ.\n\u0005q#!AD'fCN,(/\u001a3NKRDw\u000e\u001a\u0005\u0006=\u0002!IaX\u0001\u0006W2\f7o\u001d\u000b\u0003\u0011\u0002DQAX/A\u0002\u0005\u0004\"A\u00112\n\u0005\r$!!D'fCN,(/\u001a3DY\u0006\u001c8\u000fC\u0003f\u0001\u0011%a-\u0001\u0003qC\u000e\\GC\u0001%h\u0011\u0015)G\r1\u0001i!\t\u0011\u0015.\u0003\u0002k\t\tyQ*Z1tkJ,G\rU1dW\u0006<W\r")
public class ScoverageXmlWriter
extends BaseReportWriter {
    private final File outputDir;
    private final boolean debug;

    public void write(Coverage coverage) {
        File file = IOUtils$.MODULE$.reportFile(this.outputDir, this.debug);
        PrettyPrinter qual$1 = new PrettyPrinter(120, 4);
        Node x$1 = this.xml(coverage);
        NamespaceBinding x$2 = qual$1.format$default$2();
        IOUtils$.MODULE$.writeToFile(file, qual$1.format(x$1, x$2));
    }

    /*
     * WARNING - void declaration
     */
    private Node xml(Coverage coverage) {
        void var3_3;
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("timestamp", ((Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis())).toString(), (MetaData)$md);
        $md = new UnprefixedAttribute("version", (Seq)new Text("1.0"), (MetaData)$md);
        $md = new UnprefixedAttribute("branch-rate", coverage.branchCoverageFormatted(), (MetaData)$md);
        $md = new UnprefixedAttribute("statement-rate", coverage.statementCoverageFormatted(), (MetaData)$md);
        $md = new UnprefixedAttribute("statements-invoked", ((Object)BoxesRunTime.boxToInteger((int)coverage.invokedStatementCount())).toString(), (MetaData)$md);
        $md = new UnprefixedAttribute("statement-count", ((Object)BoxesRunTime.boxToInteger((int)coverage.statementCount())).toString(), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus(coverage.packages().map((Function1 & Serializable & scala.Serializable)pack -> this.pack((MeasuredPackage)pack), Seq$.MODULE$.canBuildFrom()));
        $buf2.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "packages", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "scoverage", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var3_3);
    }

    private Node statement(Statement stmt) {
        Elem elem;
        boolean bl = this.debug;
        if (bl) {
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("ignored", ((Object)BoxesRunTime.boxToBoolean((boolean)stmt.ignored())).toString(), (MetaData)$md);
            $md = new UnprefixedAttribute("invocation-count", ((Object)BoxesRunTime.boxToInteger((int)stmt.count())).toString(), (MetaData)$md);
            $md = new UnprefixedAttribute("branch", ((Object)BoxesRunTime.boxToBoolean((boolean)stmt.branch())).toString(), (MetaData)$md);
            $md = new UnprefixedAttribute("tree", Serializer$.MODULE$.escape(stmt.treeName()), (MetaData)$md);
            $md = new UnprefixedAttribute("symbol", Serializer$.MODULE$.escape(stmt.symbolName()), (MetaData)$md);
            $md = new UnprefixedAttribute("line", ((Object)BoxesRunTime.boxToInteger((int)stmt.line())).toString(), (MetaData)$md);
            $md = new UnprefixedAttribute("end", ((Object)BoxesRunTime.boxToInteger((int)stmt.end())).toString(), (MetaData)$md);
            $md = new UnprefixedAttribute("start", ((Object)BoxesRunTime.boxToInteger((int)stmt.start())).toString(), (MetaData)$md);
            $md = new UnprefixedAttribute("method", stmt.location().method(), (MetaData)$md);
            $md = new UnprefixedAttribute("source", stmt.source(), (MetaData)$md);
            $md = new UnprefixedAttribute("full-class-name", stmt.location().fullClassName(), (MetaData)$md);
            $md = new UnprefixedAttribute("class-type", stmt.location().classType().toString(), (MetaData)$md);
            $md = new UnprefixedAttribute("class", stmt.location().className(), (MetaData)$md);
            $md = new UnprefixedAttribute("package", stmt.location().packageName(), (MetaData)$md);
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("\n          "));
            $buf.$amp$plus((Object)Serializer$.MODULE$.escape(stmt.desc()));
            $buf.$amp$plus((Object)new Text("\n        "));
            elem = new Elem(null, "statement", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
        } else if (!bl) {
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("ignored", ((Object)BoxesRunTime.boxToBoolean((boolean)stmt.ignored())).toString(), (MetaData)$md);
            $md = new UnprefixedAttribute("invocation-count", ((Object)BoxesRunTime.boxToInteger((int)stmt.count())).toString(), (MetaData)$md);
            $md = new UnprefixedAttribute("branch", ((Object)BoxesRunTime.boxToBoolean((boolean)stmt.branch())).toString(), (MetaData)$md);
            $md = new UnprefixedAttribute("line", ((Object)BoxesRunTime.boxToInteger((int)stmt.line())).toString(), (MetaData)$md);
            $md = new UnprefixedAttribute("end", ((Object)BoxesRunTime.boxToInteger((int)stmt.end())).toString(), (MetaData)$md);
            $md = new UnprefixedAttribute("start", ((Object)BoxesRunTime.boxToInteger((int)stmt.start())).toString(), (MetaData)$md);
            $md = new UnprefixedAttribute("method", stmt.location().method(), (MetaData)$md);
            $md = new UnprefixedAttribute("source", stmt.source(), (MetaData)$md);
            $md = new UnprefixedAttribute("full-class-name", stmt.location().fullClassName(), (MetaData)$md);
            $md = new UnprefixedAttribute("class-type", stmt.location().classType().toString(), (MetaData)$md);
            $md = new UnprefixedAttribute("class", stmt.location().className(), (MetaData)$md);
            $md = new UnprefixedAttribute("package", stmt.location().packageName(), (MetaData)$md);
            elem = new Elem(null, "statement", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, true, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[0]));
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
        }
        return elem;
    }

    /*
     * WARNING - void declaration
     */
    private Node method(MeasuredMethod method) {
        void var3_3;
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("branch-rate", method.branchCoverageFormatted(), (MetaData)$md);
        $md = new UnprefixedAttribute("statement-rate", method.statementCoverageFormatted(), (MetaData)$md);
        $md = new UnprefixedAttribute("statements-invoked", ((Object)BoxesRunTime.boxToInteger((int)method.invokedStatementCount())).toString(), (MetaData)$md);
        $md = new UnprefixedAttribute("statement-count", ((Object)BoxesRunTime.boxToInteger((int)method.statementCount())).toString(), (MetaData)$md);
        $md = new UnprefixedAttribute("name", method.name(), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus(method.statements().map((Function1 & Serializable & scala.Serializable)stmt -> this.statement((Statement)stmt), scala.collection.Iterable$.MODULE$.canBuildFrom()));
        $buf2.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "statements", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "method", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private Node klass(MeasuredClass klass) {
        void var3_3;
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("branch-rate", klass.branchCoverageFormatted(), (MetaData)$md);
        $md = new UnprefixedAttribute("statement-rate", klass.statementCoverageFormatted(), (MetaData)$md);
        $md = new UnprefixedAttribute("statements-invoked", ((Object)BoxesRunTime.boxToInteger((int)klass.invokedStatementCount())).toString(), (MetaData)$md);
        $md = new UnprefixedAttribute("statement-count", ((Object)BoxesRunTime.boxToInteger((int)klass.statementCount())).toString(), (MetaData)$md);
        $md = new UnprefixedAttribute("filename", this.relativeSource(klass.source()), (MetaData)$md);
        $md = new UnprefixedAttribute("name", klass.fullClassName(), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus(klass.methods().map((Function1 & Serializable & scala.Serializable)method -> this.method((MeasuredMethod)method), Seq$.MODULE$.canBuildFrom()));
        $buf2.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "methods", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "class", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private Node pack(MeasuredPackage pack) {
        void var3_3;
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("statement-rate", pack.statementCoverageFormatted(), (MetaData)$md);
        $md = new UnprefixedAttribute("statements-invoked", ((Object)BoxesRunTime.boxToInteger((int)pack.invokedStatementCount())).toString(), (MetaData)$md);
        $md = new UnprefixedAttribute("statement-count", ((Object)BoxesRunTime.boxToInteger((int)pack.statementCount())).toString(), (MetaData)$md);
        $md = new UnprefixedAttribute("name", pack.name(), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus(pack.classes().map((Function1 & Serializable & scala.Serializable)klass -> this.klass((MeasuredClass)klass), Iterable$.MODULE$.canBuildFrom()));
        $buf2.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "classes", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "package", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var3_3);
    }

    public ScoverageXmlWriter(Seq<File> sourceDirectories, File outputDir, boolean debug) {
        this.outputDir = outputDir;
        this.debug = debug;
        super(sourceDirectories, outputDir);
    }

    public ScoverageXmlWriter(File sourceDir, File outputDir, boolean debug) {
        this((Seq<File>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new File[]{sourceDir}))), outputDir, debug);
    }
}

