/*
 * Flusher.java February 2007
 *
 * Copyright (C) 2007, Niall Gallagher <niallg@users.sf.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General 
 * Public License along with this library; if not, write to the 
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
 * Boston, MA  02111-1307  USA
 */

package org.simpleframework.transport;

import java.io.IOException;

/**
 * The <code>Flusher</code> object is used to flush data to the
 * underlying socket. This allows asynchronous writes to the socket
 * to be managed in such a way that there is order to the way data
 * is delivered over the socket. This uses a selector to dispatch
 * flush invocations to the underlying socket when the socket is
 * read ready. This allows the writing thread to continue without
 * having to wait for all the data to be written to the socket.
 *
 * @author Niall Gallagher
 * 
 * @see org.simpleframework.transport.Controller
 */ 
interface Flusher {

  /**
   * Here in this method we schedule a flush when the underlying
   * writer is write ready. This allows the writer thread to return
   * without having to fully flush the content to the underlying
   * transport. This will block if references are queued.
   */          
  public void flush() throws IOException;
  
  /**
   * This is used to close the flusher ensuring that all of the
   * data within the writer will be flushed regardless of the 
   * amount of data within the writer that needs to be written. If
   * the writer does not block then this waits to be finished.
   */
  public void close() throws IOException;
}