/*
 * EventQueue.java February 2007
 *
 * Copyright (C) 2007, Niall Gallagher <niallg@users.sf.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General 
 * Public License along with this library; if not, write to the 
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
 * Boston, MA  02111-1307  USA
 */

package org.simpleframework.transport.reactor;

import java.util.concurrent.LinkedBlockingQueue;

/**
 * The <code>EventQueue</code> object is used to queue events for
 * selection. This is used by the reactor to queue events that are 
 * to be executed on a given I/O event. It allows events to be
 * queued in such a way that the caller does not block.
 *
 * @author Niall Gallagher
 */ 
class EventQueue extends LinkedBlockingQueue<Event> {

  /**
   * Constructor for the <code>EventQueue</code> object. This is 
   * used to create a non-blocking queue to schedule events for
   * execution. This allows any number of events to be inserted
   * for selection so the associated channels can be registered.
   */
  public EventQueue() {
    super();          
  }        
}


