/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.transport.reactor;

import java.io.IOException;
import java.nio.channels.Channel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Executor;
import org.simpleframework.transport.reactor.CancelEvent;
import org.simpleframework.transport.reactor.Distributor;
import org.simpleframework.transport.reactor.Event;
import org.simpleframework.transport.reactor.EventQueue;
import org.simpleframework.transport.reactor.Operation;
import org.simpleframework.transport.reactor.SelectEvent;

class EventDistributor
extends Thread
implements Distributor {
    private ChannelMap table;
    private EventQueue ready;
    private Executor executor;
    private Selector selector = Selector.open();
    private long expiry;
    private boolean cancel;
    private volatile boolean dead;

    public EventDistributor(Executor executor) throws IOException {
        this(executor, true);
    }

    public EventDistributor(Executor executor, boolean cancel) throws IOException {
        this(executor, cancel, 120000L);
    }

    public EventDistributor(Executor executor, boolean cancel, long expiry) throws IOException {
        this.table = new ChannelMap();
        this.ready = new EventQueue();
        this.executor = executor;
        this.cancel = cancel;
        this.expiry = expiry;
        this.start();
    }

    public void run() {
        while (!this.dead) {
            try {
                this.register();
                this.cancel();
                this.expire();
                this.distribute();
            }
            catch (Exception e) {}
        }
    }

    public void process(Operation task, int require) throws IOException {
        SelectEvent event = new SelectEvent(task, require, this.expiry);
        if (!this.dead) {
            this.ready.offer(event);
            this.selector.wakeup();
        }
    }

    public void close() throws IOException {
        this.dead = true;
        this.selector.close();
    }

    private void expire() throws IOException {
        Set<SelectionKey> set = this.selector.keys();
        if (this.cancel) {
            long time = System.currentTimeMillis();
            for (SelectionKey key : set) {
                this.expire(key, time);
            }
        }
    }

    private void expire(SelectionKey key, long time) throws IOException {
        long expiry;
        Event task = (Event)key.attachment();
        if (task != null && (expiry = task.getExpiry()) < time) {
            this.expire(key, task);
        }
    }

    private void expire(SelectionKey key, Event event) throws IOException {
        CancelEvent cancel = new CancelEvent(event);
        if (key != null) {
            key.attach(cancel);
            key.cancel();
        }
        this.process(key);
    }

    private void cancel() throws IOException {
        Collection list = this.table.values();
        for (SelectionKey key : list) {
            key.cancel();
        }
        this.table.clear();
    }

    private void register() throws IOException {
        while (!this.ready.isEmpty()) {
            Event event = (Event)this.ready.poll();
            if (event == null) continue;
            this.register(event);
        }
    }

    private void register(Event event) throws IOException {
        int require = event.getInterest();
        this.register(event, require);
    }

    private void register(Event event, int require) throws IOException {
        SelectableChannel channel = event.getChannel();
        SelectionKey key = (SelectionKey)this.table.remove(channel);
        if (key != null) {
            key.interestOps(require);
            key.attach(event);
        } else if (channel.isOpen()) {
            this.select(channel, require).attach(event);
        }
    }

    private SelectionKey select(SelectableChannel channel, int require) throws IOException {
        return channel.register(this.selector, require);
    }

    private void distribute() throws IOException {
        if (this.selector.select(5000L) > 0 && !this.dead) {
            this.process();
        }
    }

    private void process() throws IOException {
        Set<SelectionKey> keys = this.selector.selectedKeys();
        Iterator<SelectionKey> ready = keys.iterator();
        while (ready.hasNext()) {
            SelectionKey key = ready.next();
            if (key != null) {
                ready.remove();
            }
            if (key == null) continue;
            this.process(key);
        }
    }

    private void process(SelectionKey key) throws IOException {
        Runnable task = (Runnable)key.attachment();
        SelectableChannel channel = key.channel();
        if (this.cancel) {
            this.table.put(channel, key);
        }
        this.executor.execute(task);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ChannelMap
    extends HashMap<Channel, SelectionKey> {
    }
}

