/*
 * Decompiled with CFR 0.152.
 */
package org.skyscreamer.jsonassert;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.skyscreamer.jsonassert.JSONCompare;
import org.skyscreamer.jsonassert.JSONCompareMode;
import org.skyscreamer.jsonassert.JSONCompareResult;
import org.skyscreamer.jsonassert.JSONParser;

public class JSONAssert {
    public static void assertEquals(String expectedStr, JSONObject actual, boolean strict) throws JSONException {
        Object expected = JSONParser.parseJSON(expectedStr);
        if (!(expected instanceof JSONObject)) {
            throw new AssertionError((Object)"Expecting a JSON array, but passing in a JSON object");
        }
        JSONAssert.assertEquals((JSONObject)expected, actual, strict);
    }

    public static void assertEquals(String expectedStr, JSONArray actual, boolean strict) throws JSONException {
        Object expected = JSONParser.parseJSON(expectedStr);
        if (!(expected instanceof JSONArray)) {
            throw new AssertionError((Object)"Expecting a JSON object, but passing in a JSON array");
        }
        JSONAssert.assertEquals((JSONArray)expected, actual, strict);
    }

    public static void assertEquals(String expectedStr, String actualStr, boolean strict) throws JSONException {
        JSONCompareResult result = JSONCompare.compareJSON(expectedStr, actualStr, strict ? JSONCompareMode.STRICT : JSONCompareMode.LENIENT);
        if (result.failed()) {
            throw new AssertionError((Object)result.getMessage());
        }
    }

    public static void assertEquals(JSONObject expected, JSONObject actual, boolean strict) throws JSONException {
        JSONCompareResult result = JSONCompare.compareJSON(expected, actual, strict ? JSONCompareMode.STRICT : JSONCompareMode.LENIENT);
        if (result.failed()) {
            throw new AssertionError((Object)result.getMessage());
        }
    }

    public static void assertEquals(JSONArray expected, JSONArray actual, boolean strict) throws JSONException {
        JSONCompareResult result = JSONCompare.compareJSON(expected, actual, strict ? JSONCompareMode.STRICT : JSONCompareMode.LENIENT);
        if (result.failed()) {
            throw new AssertionError((Object)result.getMessage());
        }
    }
}

