/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.spark.singularity.boot;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.smallmind.spark.singularity.boot.SingularityClassLoader;

public class SingularityEntryPoint {
    public static void main(String ... args) throws IOException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Manifest manifest;
        ProtectionDomain protectionDomain = SingularityEntryPoint.class.getProtectionDomain();
        CodeSource codeSource = protectionDomain.getCodeSource();
        try (JarInputStream jarInputStream = new JarInputStream(codeSource.getLocation().openStream());){
            manifest = jarInputStream.getManifest();
            Thread.currentThread().setContextClassLoader(new SingularityClassLoader(null, manifest, codeSource.getLocation(), jarInputStream));
        }
        String mainClass = manifest.getMainAttributes().getValue(new Attributes.Name("Singularity-Class"));
        if (mainClass != null && !mainClass.equals(SingularityEntryPoint.class.getName())) {
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(mainClass);
            Method main = clazz.getMethod("main", String[].class);
            main.invoke(null, new Object[]{args});
        }
    }
}

