/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.web.jwt;

import java.io.UnsupportedEncodingException;
import org.smallmind.nutsnbolts.http.Base64Codec;
import org.smallmind.web.jersey.util.JsonCodec;
import org.smallmind.web.jwt.JWTKeyMaster;

public class JWTCodec {
    public static String encode(Object claims, JWTKeyMaster keyMaster) throws Exception {
        return JWTCodec.encode(claims, keyMaster, false);
    }

    public static String encode(Object claims, JWTKeyMaster keyMaster, boolean urlSafe) throws Exception {
        String header = "{\"typ\":\"JWT\",\r\n \"alg\":\"" + keyMaster.getEncryptionAlgorithm().name() + "\"}";
        String encodedHeader = urlSafe ? Base64Codec.urlSafeEncode((String)header) : Base64Codec.encode((String)header);
        String encodedClaims = urlSafe ? Base64Codec.urlSafeEncode((byte[])JsonCodec.writeAsBytes((Object)claims)) : Base64Codec.encode((byte[])JsonCodec.writeAsBytes((Object)claims));
        String prologue = encodedHeader + '.' + encodedClaims;
        byte[] encryptedBytes = keyMaster.getEncryptionAlgorithm().encrypt(keyMaster.getKey(), prologue);
        String epilogue = urlSafe ? Base64Codec.urlSafeEncode((byte[])encryptedBytes) : Base64Codec.encode((byte[])encryptedBytes);
        return prologue + '.' + epilogue;
    }

    public static <T> T decode(String jwtToken, JWTKeyMaster keyMaster, Class<T> claimsClass) throws Exception {
        return JWTCodec.decode(jwtToken, keyMaster, claimsClass, false);
    }

    public static <T> T decode(String jwtToken, JWTKeyMaster keyMaster, Class<T> claimsClass, boolean urlSafe) throws Exception {
        String[] parts = jwtToken.split("\\.", -1);
        if (parts.length != 3) {
            throw new UnsupportedEncodingException("Not a JWT token");
        }
        if (!keyMaster.getEncryptionAlgorithm().verify(keyMaster.getKey(), parts, urlSafe)) {
            throw new UnsupportedEncodingException("Not a JWT token");
        }
        return (T)JsonCodec.read((byte[])(urlSafe ? Base64Codec.urlSafeDecode((String)parts[1]) : Base64Codec.decode((String)parts[1])), claimsClass);
    }
}

