/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.web.websocket;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.net.URI;
import java.security.NoSuchAlgorithmException;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.smallmind.nutsnbolts.http.Base64Codec;
import org.smallmind.nutsnbolts.security.EncryptionUtility;
import org.smallmind.nutsnbolts.security.HashAlgorithm;
import org.smallmind.nutsnbolts.util.Tuple;
import org.smallmind.web.websocket.ExtensionParameter;
import org.smallmind.web.websocket.HandshakeResponse;
import org.smallmind.web.websocket.SyntaxException;
import org.smallmind.web.websocket.WebSocketExtension;

public class Handshake {
    private static final Pattern HTTP_STATUS_PATTERN = Pattern.compile("HTTP/(\\d+\\.\\d+)\\s(\\d+)\\s(.+)");
    private static final Pattern HTTP_HEADER_PATTERN = Pattern.compile("([^:]+):\\s*(.+)\\s*");

    public static Tuple<String, String> constructHeaders(int protocolVersion, URI uri, byte[] keyBytes, WebSocketExtension[] extensions, String ... protocols) throws IOException {
        String extesnionsValue;
        Tuple headerTuple = new Tuple();
        headerTuple.addPair((Object)"Host", (Object)(uri.getHost().toLowerCase() + ':' + (uri.getPort() != -1 ? uri.getPort() : (uri.getScheme().equals("ws") ? 80 : 443))));
        headerTuple.addPair((Object)"Upgrade", (Object)"websocket");
        headerTuple.addPair((Object)"Connection", (Object)"Upgrade");
        headerTuple.addPair((Object)"Sec-WebSocket-Key", (Object)Base64Codec.encode((byte[])keyBytes));
        headerTuple.addPair((Object)"Sec-WebSocket-Version", (Object)String.valueOf(protocolVersion));
        if (protocols != null && protocols.length > 0) {
            StringBuilder protocolBuilder = new StringBuilder();
            for (String protocol : protocols) {
                if (protocolBuilder.length() > 0) {
                    protocolBuilder.append(',');
                }
                protocolBuilder.append(protocol);
            }
            headerTuple.addPair((Object)"Sec-WebSocket-Protocol", (Object)protocolBuilder.toString());
        }
        if ((extesnionsValue = HandshakeResponse.getExtensionsAsString(extensions)) != null) {
            headerTuple.addPair((Object)"Sec-WebSocket-Extensions", (Object)extesnionsValue);
        }
        return headerTuple;
    }

    public static byte[] constructRequest(URI uri, Tuple<String, String> headerTuple) throws IOException {
        StringBuilder handshakeBuilder = new StringBuilder();
        handshakeBuilder.append("GET ").append(uri.getPath() == null || uri.getPath().length() == 0 ? "/" : uri.getPath());
        if (uri.getQuery() != null && uri.getQuery().length() > 0) {
            handshakeBuilder.append('?').append(uri.getQuery());
        }
        handshakeBuilder.append(" HTTP/1.1").append('\n');
        for (String key : headerTuple.getKeys()) {
            for (String value : headerTuple.getValues((Object)key)) {
                handshakeBuilder.append(key).append(": ").append(value).append('\n');
            }
        }
        handshakeBuilder.append('\n');
        return handshakeBuilder.toString().getBytes();
    }

    public static HandshakeResponse validateResponse(Tuple<String, String> headerTuple, String response, byte[] keyBytes, WebSocketExtension[] installedExtensions, String ... protocols) throws IOException, NoSuchAlgorithmException, SyntaxException {
        String httpField;
        String httpStatus;
        BufferedReader reader = new BufferedReader(new StringReader(response));
        LinkedList<WebSocketExtension> negotiatedExtensionList = new LinkedList<WebSocketExtension>();
        WebSocketExtension[] negotiatedExtensions = null;
        String negotiatedProtocol = "";
        while ((httpStatus = reader.readLine()) != null && httpStatus.length() == 0) {
        }
        if (httpStatus == null) {
            throw new SyntaxException("The handshake response could not be parsed", new Object[0]);
        }
        Matcher httpStatusMatcher = HTTP_STATUS_PATTERN.matcher(httpStatus);
        if (!httpStatusMatcher.matches()) {
            throw new SyntaxException("The http status line(%s) of the handshake response could not be parsed", httpStatus);
        }
        if (!httpStatusMatcher.group(2).equals("101")) {
            throw new SyntaxException("Incorrect http status code(%s) in the handshake response", httpStatusMatcher.group(2));
        }
        while ((httpField = reader.readLine()) != null && httpField.length() > 0) {
            Matcher fieldMatcher = HTTP_HEADER_PATTERN.matcher(httpField);
            if (!fieldMatcher.matches()) {
                throw new SyntaxException("The http header line(%s) of the handshake response could not be parsed", httpField);
            }
            if (headerTuple.containsKey((Object)fieldMatcher.group(1))) continue;
            headerTuple.addPair((Object)fieldMatcher.group(1), (Object)fieldMatcher.group(2));
        }
        if (!headerTuple.containsKey((Object)"Upgrade")) {
            throw new SyntaxException("The http header does not contain an 'Upgrade' field", new Object[0]);
        }
        if (!((String)headerTuple.getValue((Object)"Upgrade")).equalsIgnoreCase("websocket")) {
            throw new SyntaxException("The 'Upgrade' field(%s) of the http header does not contain the value 'websocket'", headerTuple.getValue((Object)"Upgrade"));
        }
        if (!headerTuple.containsKey((Object)"Connection")) {
            throw new SyntaxException("The http header does not contain a 'Connection' field", new Object[0]);
        }
        if (!((String)headerTuple.getValue((Object)"Connection")).equalsIgnoreCase("upgrade")) {
            throw new SyntaxException("The 'Connection' field(%s) of the http header does not contain the value 'upgrade'", headerTuple.getValue((Object)"Connection"));
        }
        if (!headerTuple.containsKey((Object)"Sec-WebSocket-Accept")) {
            throw new SyntaxException("The http header does not contain a 'Sec-WebSocket-Accept' field", new Object[0]);
        }
        if (!((String)headerTuple.getValue((Object)"Sec-WebSocket-Accept")).equals(Base64Codec.encode((byte[])EncryptionUtility.hash((HashAlgorithm)HashAlgorithm.SHA_1, (byte[])(Base64Codec.encode((byte[])keyBytes) + "258EAFA5-E914-47DA-95CA-C5AB0DC85B11").getBytes())))) {
            throw new SyntaxException("The 'Sec-WebSocket-Accept' field(%s) of the http header does not contain the correct value", headerTuple.getValue((Object)"Sec-WebSocket-Accept"));
        }
        if (headerTuple.containsKey((Object)"Sec-WebSocket-Protocol")) {
            String headerProtocol = (String)headerTuple.getValue((Object)"Sec-WebSocket-Protocol");
            boolean matched = false;
            for (String protocol : protocols) {
                if (!protocol.equals(headerProtocol)) continue;
                negotiatedProtocol = protocol;
                matched = true;
                break;
            }
            if (!matched) {
                throw new SyntaxException("The 'Sec-WebSocket-Protocol' field(%s) of the http header does not contain one of the requested sub-protocols", headerProtocol);
            }
        }
        if (headerTuple.containsKey((Object)"Sec-WebSocket-Extensions")) {
            for (String extensionValue : headerTuple.getValues((Object)"Sec-WebSocket-Extensions")) {
                String[] splitExtensionValues = extensionValue.split(",", -1);
                if (splitExtensionValues.length == 0) {
                    throw new SyntaxException("The 'Sec-WebSocket-Extensions' contains an empty header value", new Object[0]);
                }
                block4: for (String splitExtensionValue : splitExtensionValues) {
                    String[] splitParameterValues = splitExtensionValue.split(";", -1);
                    if (splitParameterValues.length <= 0) continue;
                    LinkedList<ExtensionParameter> parameterList = new LinkedList<ExtensionParameter>();
                    String extensionName = splitParameterValues[0].trim();
                    if (extensionName.isEmpty()) {
                        throw new SyntaxException("The 'Sec-WebSocket-Extensions' contains an empty extension name", new Object[0]);
                    }
                    if (splitParameterValues.length > 1) {
                        for (int index = 1; index < splitParameterValues.length; ++index) {
                            int equalsPos = splitParameterValues[index].indexOf(61);
                            if (equalsPos < 0) continue;
                            String parameterName = splitParameterValues[index].substring(0, equalsPos).trim();
                            if (parameterName.isEmpty()) {
                                throw new SyntaxException("The 'Sec-WebSocket-Extensions' contains an empty parameter name", new Object[0]);
                            }
                            String parameterValue = splitParameterValues[index].substring(equalsPos + 1).trim();
                            if (parameterValue.isEmpty()) {
                                throw new SyntaxException("The 'Sec-WebSocket-Extensions' contains an empty parameter value", new Object[0]);
                            }
                            parameterList.add(new ExtensionParameter(parameterName, parameterValue));
                        }
                    }
                    ExtensionParameter[] parameters = new ExtensionParameter[parameterList.size()];
                    parameterList.toArray(parameters);
                    WebSocketExtension negotiatedExtension = new WebSocketExtension(extensionName, parameters);
                    for (WebSocketExtension installedExtension : installedExtensions) {
                        if (!installedExtension.equals(negotiatedExtension)) continue;
                        negotiatedExtensionList.add(negotiatedExtension);
                        continue block4;
                    }
                }
                negotiatedExtensions = new WebSocketExtension[negotiatedExtensionList.size()];
                negotiatedExtensionList.toArray(negotiatedExtensions);
            }
        }
        return new HandshakeResponse(negotiatedProtocol, negotiatedExtensions);
    }
}

