/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.web.websocket.spi;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.CloseReason;
import javax.websocket.Decoder;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.Extension;
import javax.websocket.MessageHandler;
import javax.websocket.PongMessage;
import javax.websocket.RemoteEndpoint;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import org.smallmind.nutsnbolts.http.HTTPCodec;
import org.smallmind.nutsnbolts.util.SnowflakeId;
import org.smallmind.web.websocket.CloseCode;
import org.smallmind.web.websocket.CloseListener;
import org.smallmind.web.websocket.ConnectionState;
import org.smallmind.web.websocket.WebSocket;
import org.smallmind.web.websocket.WebSocketException;
import org.smallmind.web.websocket.spi.ConfiguratorHandshakeListener;
import org.smallmind.web.websocket.spi.DecodedByteBufferHandler;
import org.smallmind.web.websocket.spi.DecodedInputStreamHandler;
import org.smallmind.web.websocket.spi.DecodedReaderHandler;
import org.smallmind.web.websocket.spi.DecodedStringHandler;
import org.smallmind.web.websocket.spi.GenericParameterUtility;
import org.smallmind.web.websocket.spi.MalformedMessageHandlerException;
import org.smallmind.web.websocket.spi.RemoteEndpointImpl;
import org.smallmind.web.websocket.spi.SessionRuntimeException;

public class SessionImpl
implements Session,
CloseListener {
    private final WebSocket webSocket;
    private final WebSocketContainer container;
    private final Endpoint endpoint;
    private final ClientEndpointConfig endpointConfig;
    private final AtomicReference<MessageHandler> textMessageHandlerRef = new AtomicReference();
    private final AtomicReference<MessageHandler> binaryMessageHandlerRef = new AtomicReference();
    private final AtomicReference<MessageHandler> pongMessageHandlerRef = new AtomicReference();
    private final HashMap<Class<? extends Decoder>, Decoder> decoderInstanceMap = new HashMap();
    private final String id = SnowflakeId.newInstance().generateHexEncoding();

    public SessionImpl(WebSocketContainer container, URI uri, final Endpoint endpoint, ClientEndpointConfig endpointConfig) throws IOException, NoSuchAlgorithmException, WebSocketException {
        String[] preferredSubProtocols = null;
        this.container = container;
        this.endpoint = endpoint;
        this.endpointConfig = endpointConfig;
        if (endpointConfig.getPreferredSubprotocols() != null && !endpointConfig.getPreferredSubprotocols().isEmpty()) {
            preferredSubProtocols = new String[endpointConfig.getPreferredSubprotocols().size()];
            endpointConfig.getPreferredSubprotocols().toArray(preferredSubProtocols);
        }
        this.webSocket = new WebSocket(uri, new ConfiguratorHandshakeListener(endpointConfig.getConfigurator()), preferredSubProtocols){

            @Override
            public void onError(Exception exception) {
                endpoint.onError((Session)SessionImpl.this, (Throwable)exception);
            }

            @Override
            public void onPong(byte[] message) {
                MessageHandler pongMessageHandler = (MessageHandler)SessionImpl.this.pongMessageHandlerRef.get();
                if (pongMessageHandler != null) {
                    if (pongMessageHandler instanceof MessageHandler.Whole) {
                        ((MessageHandler.Whole)pongMessageHandler).onMessage((Object)message);
                    } else {
                        ((MessageHandler.Partial)pongMessageHandler).onMessage((Object)message, true);
                    }
                }
            }

            @Override
            public void onText(String message) {
                MessageHandler textMessageHandler = (MessageHandler)SessionImpl.this.textMessageHandlerRef.get();
                if (textMessageHandler != null) {
                    if (textMessageHandler instanceof MessageHandler.Whole) {
                        ((MessageHandler.Whole)textMessageHandler).onMessage((Object)message);
                    } else {
                        ((MessageHandler.Partial)textMessageHandler).onMessage((Object)message, true);
                    }
                }
            }

            @Override
            public void onBinary(byte[] message) {
                MessageHandler binaryMessageHandler = (MessageHandler)SessionImpl.this.binaryMessageHandlerRef.get();
                if (binaryMessageHandler != null) {
                    if (binaryMessageHandler instanceof MessageHandler.Whole) {
                        ((MessageHandler.Whole)binaryMessageHandler).onMessage((Object)message);
                    } else {
                        ((MessageHandler.Partial)binaryMessageHandler).onMessage((Object)message, true);
                    }
                }
            }
        };
        this.webSocket.setMaxIdleTimeoutMilliseconds(container.getDefaultMaxSessionIdleTimeout());
        this.webSocket.setMaxTextBufferSize(container.getDefaultMaxTextMessageBufferSize());
        this.webSocket.setMaxBinaryBufferSize(container.getDefaultMaxBinaryMessageBufferSize());
        this.webSocket.addCloseListener(this);
        endpoint.onOpen((Session)this, (EndpointConfig)endpointConfig);
    }

    public WebSocketContainer getContainer() {
        return this.container;
    }

    public void addMessageHandler(MessageHandler handler) throws IllegalStateException {
        if (handler instanceof MessageHandler.Whole) {
            this.addMessageHandler(GenericParameterUtility.getTypeParameter(handler.getClass(), MessageHandler.Whole.class), (MessageHandler.Whole)handler);
        }
        if (handler instanceof MessageHandler.Partial) {
            this.addMessageHandler(GenericParameterUtility.getTypeParameter(handler.getClass(), MessageHandler.Partial.class), (MessageHandler.Partial)handler);
        }
    }

    public synchronized <T> void addMessageHandler(Class<T> clazz, MessageHandler.Whole<T> messageHandler) {
        boolean assigned = false;
        if (String.class.isAssignableFrom(clazz)) {
            this.assignTextMessageHandler((MessageHandler)messageHandler);
            assigned = true;
        }
        if (Reader.class.isAssignableFrom(clazz)) {
            this.assignTextMessageHandler((MessageHandler)messageHandler);
            assigned = true;
        }
        if (ByteBuffer.class.isAssignableFrom(clazz)) {
            this.assignBinaryMessageHandler((MessageHandler)messageHandler);
            assigned = true;
        }
        if (InputStream.class.isAssignableFrom(clazz)) {
            this.assignBinaryMessageHandler((MessageHandler)messageHandler);
            assigned = true;
        }
        if (PongMessage.class.isAssignableFrom(clazz)) {
            this.assignPongMessageHandler((MessageHandler)messageHandler);
            assigned = true;
        }
        if (!assigned) {
            try {
                assigned = this.assignDecoder(clazz, messageHandler);
            }
            catch (IllegalAccessException | InstantiationException exception) {
                throw new MalformedMessageHandlerException(exception);
            }
        }
        if (!assigned) {
            throw new MalformedMessageHandlerException("Illegal parametrized type(%s) for whole message handler(%s)", clazz.getName(), messageHandler.getClass().getName());
        }
    }

    public synchronized <T> void addMessageHandler(Class<T> clazz, MessageHandler.Partial<T> messageHandler) {
        boolean assigned = false;
        if (String.class.isAssignableFrom(clazz)) {
            this.assignTextMessageHandler((MessageHandler)messageHandler);
            assigned = true;
        }
        if (ByteBuffer.class.isAssignableFrom(clazz)) {
            this.assignBinaryMessageHandler((MessageHandler)messageHandler);
            assigned = true;
        }
        if (byte[].class.isAssignableFrom(clazz)) {
            this.assignBinaryMessageHandler((MessageHandler)messageHandler);
            assigned = true;
        }
        if (!assigned) {
            throw new MalformedMessageHandlerException("Illegal parametrized type(%s) for partial message handler(%s)", clazz.getName(), messageHandler.getClass().getName());
        }
    }

    private <T> boolean assignDecoder(Class<T> clazz, MessageHandler.Whole<T> messageHandler) throws IllegalAccessException, InstantiationException {
        boolean assigned = false;
        for (Class decoderClass : this.endpointConfig.getDecoders()) {
            Decoder decoder;
            if (Decoder.Text.class.isAssignableFrom(decoderClass) && clazz.isAssignableFrom(GenericParameterUtility.getTypeParameter(decoderClass, Decoder.Text.class))) {
                decoder = this.decoderInstanceMap.get(decoderClass);
                if (decoder == null) {
                    decoder = (Decoder)decoderClass.newInstance();
                    this.decoderInstanceMap.put(decoderClass, decoder);
                }
                this.assignTextMessageHandler((MessageHandler)new DecodedStringHandler<T>(this, this.endpoint, (Decoder.Text)decoder, messageHandler));
                assigned = true;
            }
            if (Decoder.TextStream.class.isAssignableFrom(decoderClass) && clazz.isAssignableFrom(GenericParameterUtility.getTypeParameter(decoderClass, Decoder.TextStream.class))) {
                decoder = this.decoderInstanceMap.get(decoderClass);
                if (decoder == null) {
                    decoder = (Decoder)decoderClass.newInstance();
                    this.decoderInstanceMap.put(decoderClass, decoder);
                }
                this.assignTextMessageHandler((MessageHandler)new DecodedReaderHandler<T>(this, this.endpoint, (Decoder.TextStream)decoder, messageHandler));
                assigned = true;
            }
            if (Decoder.Binary.class.isAssignableFrom(decoderClass) && clazz.isAssignableFrom(GenericParameterUtility.getTypeParameter(decoderClass, Decoder.Binary.class))) {
                decoder = this.decoderInstanceMap.get(decoderClass);
                if (decoder == null) {
                    decoder = (Decoder)decoderClass.newInstance();
                    this.decoderInstanceMap.put(decoderClass, decoder);
                }
                this.assignBinaryMessageHandler((MessageHandler)new DecodedByteBufferHandler<T>(this, this.endpoint, (Decoder.Binary)decoder, messageHandler));
                assigned = true;
            }
            if (!Decoder.BinaryStream.class.isAssignableFrom(decoderClass) || !clazz.isAssignableFrom(GenericParameterUtility.getTypeParameter(decoderClass, Decoder.BinaryStream.class))) continue;
            decoder = this.decoderInstanceMap.get(decoderClass);
            if (decoder == null) {
                decoder = (Decoder)decoderClass.newInstance();
                this.decoderInstanceMap.put(decoderClass, decoder);
            }
            this.assignBinaryMessageHandler((MessageHandler)new DecodedInputStreamHandler<T>(this, this.endpoint, (Decoder.BinaryStream)decoder, messageHandler));
            assigned = true;
        }
        return assigned;
    }

    private void assignTextMessageHandler(MessageHandler messageHandler) {
        if (!this.textMessageHandlerRef.compareAndSet(null, messageHandler)) {
            throw new IllegalStateException("Session is already assigned a text message handler");
        }
    }

    private void assignBinaryMessageHandler(MessageHandler messageHandler) {
        if (!this.binaryMessageHandlerRef.compareAndSet(null, messageHandler)) {
            throw new IllegalStateException("Session is already assigned a binary message handler");
        }
    }

    private void assignPongMessageHandler(MessageHandler messageHandler) {
        if (!this.pongMessageHandlerRef.compareAndSet(null, messageHandler)) {
            throw new IllegalStateException("Session is already assigned a pong message handler");
        }
    }

    public synchronized Set<MessageHandler> getMessageHandlers() {
        MessageHandler pongMessageHandler;
        MessageHandler binaryMessageHandler;
        HashSet<MessageHandler> handlerSet = new HashSet<MessageHandler>();
        MessageHandler textMessageHandler = this.textMessageHandlerRef.get();
        if (textMessageHandler != null) {
            handlerSet.add(textMessageHandler);
        }
        if ((binaryMessageHandler = this.binaryMessageHandlerRef.get()) != null) {
            handlerSet.add(binaryMessageHandler);
        }
        if ((pongMessageHandler = this.pongMessageHandlerRef.get()) != null) {
            handlerSet.add(pongMessageHandler);
        }
        return Collections.unmodifiableSet(handlerSet);
    }

    public synchronized void removeMessageHandler(MessageHandler handler) {
        if (handler != null) {
            this.textMessageHandlerRef.compareAndSet(handler, null);
            this.binaryMessageHandlerRef.compareAndSet(handler, null);
            this.pongMessageHandlerRef.compareAndSet(handler, null);
        }
    }

    public String getProtocolVersion() {
        return String.valueOf(this.webSocket.getProtocolVersion());
    }

    public String getNegotiatedSubprotocol() {
        return this.webSocket.getNegotiatedProtocol();
    }

    public List<Extension> getNegotiatedExtensions() {
        return null;
    }

    public boolean isSecure() {
        return this.webSocket.isSecure();
    }

    public boolean isOpen() {
        return this.webSocket.getConnectionState().equals((Object)ConnectionState.OPEN);
    }

    public long getMaxIdleTimeout() {
        return this.webSocket.getMaxIdleTimeoutMilliseconds();
    }

    public void setMaxIdleTimeout(long milliseconds) {
        this.webSocket.setMaxIdleTimeoutMilliseconds(milliseconds);
    }

    public int getMaxBinaryMessageBufferSize() {
        return this.webSocket.getMaxBinaryBufferSize();
    }

    public void setMaxBinaryMessageBufferSize(int length) {
        this.webSocket.setMaxBinaryBufferSize(length);
    }

    public int getMaxTextMessageBufferSize() {
        return this.webSocket.getMaxTextBufferSize();
    }

    public void setMaxTextMessageBufferSize(int length) {
        this.webSocket.setMaxTextBufferSize(length);
    }

    @Override
    public void onClose(int code, String reason) {
        this.endpoint.onClose((Session)this, new CloseReason(CloseReason.CloseCodes.getCloseCode((int)code), reason));
    }

    public void close() {
        try {
            this.webSocket.close(CloseCode.NORMAL, CloseCode.NORMAL.name());
        }
        catch (Exception exception) {
            this.endpoint.onError((Session)this, (Throwable)exception);
        }
    }

    public void close(CloseReason closeReason) {
        try {
            this.webSocket.close(CloseCode.fromCode(closeReason.getCloseCode().getCode()), closeReason.getReasonPhrase());
        }
        catch (Exception exception) {
            this.endpoint.onError((Session)this, (Throwable)exception);
        }
    }

    public URI getRequestURI() {
        return this.webSocket.getUri();
    }

    public String getQueryString() {
        return this.webSocket.getUri().getQuery();
    }

    public Map<String, List<String>> getRequestParameterMap() {
        try {
            return HTTPCodec.urlDecode((String)this.webSocket.getUri().getQuery()).asMap();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SessionRuntimeException(unsupportedEncodingException);
        }
    }

    public Map<String, String> getPathParameters() {
        return null;
    }

    public Map<String, Object> getUserProperties() {
        return this.endpointConfig.getUserProperties();
    }

    public Principal getUserPrincipal() {
        return null;
    }

    public Set<Session> getOpenSessions() {
        HashSet<Session> sessionSet = new HashSet<Session>();
        sessionSet.add(this);
        return sessionSet;
    }

    public String getId() {
        return this.id;
    }

    public RemoteEndpoint.Async getAsyncRemote() {
        return new RemoteEndpointImpl.Async(this, this.webSocket, this.endpoint, (EndpointConfig)this.endpointConfig);
    }

    public RemoteEndpoint.Basic getBasicRemote() {
        return new RemoteEndpointImpl.Basic(this, this.webSocket, this.endpoint, (EndpointConfig)this.endpointConfig);
    }
}

