/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.web.websocket;

import java.util.List;
import javax.websocket.Extension;
import org.smallmind.web.websocket.WebSocketExtension;

public class HandshakeResponse {
    private WebSocketExtension[] extensions;
    private String protocol;

    public HandshakeResponse(String protocol, WebSocketExtension ... extensions) {
        this.protocol = protocol;
        this.extensions = extensions;
    }

    public static String getExtensionsAsString(WebSocketExtension[] extensions) {
        if (extensions != null && extensions.length > 0) {
            StringBuilder extensionBuilder = new StringBuilder();
            boolean firstExtension = true;
            for (WebSocketExtension extension : extensions) {
                if (!firstExtension) {
                    extensionBuilder.append(", ");
                }
                firstExtension = false;
                extensionBuilder.append(extension.getName());
                List<Extension.Parameter> parameterList = extension.getParameters();
                if (parameterList.isEmpty()) continue;
                for (Extension.Parameter parameter : parameterList) {
                    extensionBuilder.append("; ").append(parameter.getName()).append('=').append(parameter.getValue());
                }
            }
            return extensionBuilder.toString();
        }
        return null;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public WebSocketExtension[] getExtensions() {
        return this.extensions;
    }
}

