/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.web.websocket;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLSocketFactory;
import org.smallmind.nutsnbolts.http.Base64Codec;
import org.smallmind.nutsnbolts.io.ByteArrayIOStream;
import org.smallmind.nutsnbolts.lang.UnknownSwitchCaseException;
import org.smallmind.nutsnbolts.security.EncryptionUtility;
import org.smallmind.nutsnbolts.security.HashAlgorithm;
import org.smallmind.nutsnbolts.util.Tuple;
import org.smallmind.web.websocket.CloseCode;
import org.smallmind.web.websocket.CloseListener;
import org.smallmind.web.websocket.ConnectionState;
import org.smallmind.web.websocket.Fragment;
import org.smallmind.web.websocket.Frame;
import org.smallmind.web.websocket.Handshake;
import org.smallmind.web.websocket.HandshakeListener;
import org.smallmind.web.websocket.HandshakeResponse;
import org.smallmind.web.websocket.OpCode;
import org.smallmind.web.websocket.ProtocolValidator;
import org.smallmind.web.websocket.SyntaxException;
import org.smallmind.web.websocket.WebSocketException;
import org.smallmind.web.websocket.WebSocketExtension;

public abstract class WebSocket
implements AutoCloseable {
    private final Socket socket;
    private final ByteArrayIOStream byteArrayIOStream = new ByteArrayIOStream();
    private final MessageWorker messageWorker;
    private final ConcurrentLinkedQueue<String> pingKeyQueue = new ConcurrentLinkedQueue();
    private final AtomicReference<ConnectionState> connectionStateRef = new AtomicReference<ConnectionState>(ConnectionState.CONNECTING);
    private final AtomicReference<CloseListener> closeListenerRef = new AtomicReference();
    private final AtomicLong idleMilliseconds = new AtomicLong(0L);
    private final AtomicLong maxIdleTimeoutMilliseconds = new AtomicLong(-1L);
    private final AtomicInteger maxBinaryBufferSize = new AtomicInteger(Integer.MAX_VALUE);
    private final AtomicInteger maxTextBufferSize = new AtomicInteger(Integer.MAX_VALUE);
    private final HandshakeResponse handshakeResponse;
    private final URI uri;
    private final String url;
    private final boolean secure;
    private final byte[] rawBuffer = new byte[1024];
    private final long soTimeout = 1000L;
    private final int protocolVersion = 13;

    public WebSocket(URI uri, String ... protocols) throws IOException, NoSuchAlgorithmException, WebSocketException {
        this(uri, (HandshakeListener)null, (WebSocketExtension[])null, protocols);
    }

    public WebSocket(URI uri, WebSocketExtension[] extensions, String ... protocols) throws IOException, NoSuchAlgorithmException, WebSocketException {
        this(uri, null, extensions, protocols);
    }

    public WebSocket(URI uri, HandshakeListener handshakeListener, String ... protocols) throws IOException, NoSuchAlgorithmException, WebSocketException {
        this(uri, handshakeListener, (WebSocketExtension[])null, protocols);
    }

    public WebSocket(URI uri, HandshakeListener handshakeListener, WebSocketExtension[] extensions, String ... protocols) throws IOException, NoSuchAlgorithmException, WebSocketException {
        byte[] keyBytes = new byte[16];
        this.uri = uri;
        ThreadLocalRandom.current().nextBytes(keyBytes);
        if (!uri.isAbsolute()) {
            throw new SyntaxException("A websocket uri must be absolute", new Object[0]);
        }
        if (uri.getScheme() == null || !uri.getScheme().equals("ws") && !uri.getScheme().equals("wss")) {
            throw new SyntaxException("A websocket requires a uri with either the 'ws' or 'wss' scheme", new Object[0]);
        }
        if (uri.getFragment() != null && uri.getFragment().length() > 0) {
            throw new SyntaxException("A websocket uri may not contain a fragment", new Object[0]);
        }
        if (!ProtocolValidator.validate(protocols)) {
            throw new SyntaxException("The provided protocols(%s) are not valid", Arrays.toString(protocols));
        }
        this.url = uri.toString();
        if (uri.getScheme().equals("wss")) {
            this.socket = SSLSocketFactory.getDefault().createSocket(uri.getHost().toLowerCase(), uri.getPort() != -1 ? uri.getPort() : 443);
            this.secure = true;
        } else {
            this.socket = new Socket(uri.getHost().toLowerCase(), uri.getPort() != -1 ? uri.getPort() : 80);
            this.secure = false;
        }
        this.socket.setTcpNoDelay(true);
        this.socket.setSoTimeout(1000);
        Tuple headerTuple = Handshake.constructHeaders(13, uri, keyBytes, extensions, protocols);
        if (handshakeListener != null) {
            handshakeListener.beforeRequest(headerTuple);
        }
        this.socket.getOutputStream().write(Handshake.constructRequest(uri, headerTuple));
        headerTuple = new Tuple();
        this.handshakeResponse = Handshake.validateResponse((Tuple<String, String>)headerTuple, new String(this.read()), keyBytes, extensions, protocols);
        if (handshakeListener != null) {
            handshakeListener.afterResponse((Tuple<String, String>)headerTuple);
        }
        this.connectionStateRef.set(ConnectionState.OPEN);
        this.messageWorker = new MessageWorker();
        Thread workerThread = new Thread(this.messageWorker);
        workerThread.setDaemon(true);
        workerThread.start();
    }

    public abstract void onError(Exception var1);

    public abstract void onPong(byte[] var1);

    public abstract void onText(String var1);

    public abstract void onBinary(byte[] var1);

    public synchronized void ping(byte[] buffer) throws IOException, WebSocketException {
        if (this.connectionStateRef.get().equals((Object)ConnectionState.CLOSING) || this.connectionStateRef.get().equals((Object)ConnectionState.CLOSED)) {
            throw new WebSocketException("The websocket has been closed", new Object[0]);
        }
        try {
            this.pingKeyQueue.add(Base64Codec.encode((byte[])EncryptionUtility.hash((HashAlgorithm)HashAlgorithm.SHA_1, (byte[])buffer)));
            this.write(Frame.ping(buffer));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new WebSocketException(noSuchAlgorithmException);
        }
    }

    public synchronized void text(String message) throws IOException, WebSocketException {
        if (this.connectionStateRef.get().equals((Object)ConnectionState.CLOSING) || this.connectionStateRef.get().equals((Object)ConnectionState.CLOSED)) {
            throw new WebSocketException("The websocket has been closed", new Object[0]);
        }
        this.write(Frame.text(message));
    }

    public synchronized void binary(byte[] buffer) throws IOException, WebSocketException {
        if (this.connectionStateRef.get().equals((Object)ConnectionState.CLOSING) || this.connectionStateRef.get().equals((Object)ConnectionState.CLOSED)) {
            throw new WebSocketException("The websocket has been closed", new Object[0]);
        }
        this.write(Frame.binary(buffer));
    }

    public void addCloseListener(CloseListener closeListener) {
        this.closeListenerRef.set(closeListener);
    }

    @Override
    public void close() throws IOException, WebSocketException, InterruptedException {
        this.close(CloseCode.NORMAL);
    }

    public void close(CloseCode closeCode) throws IOException, WebSocketException, InterruptedException {
        this.close(closeCode, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(CloseCode closeCode, String reason) throws IOException, WebSocketException, InterruptedException {
        if (this.connectionStateRef.compareAndSet(ConnectionState.OPEN, ConnectionState.CLOSING)) {
            CloseListener closeListener = this.closeListenerRef.get();
            if (closeListener != null) {
                closeListener.onClose(closeCode.getCode(), reason);
            }
            try {
                this.messageWorker.abort();
                this.write(Frame.close(closeCode.getCodeAsBytes(), reason));
            }
            finally {
                this.connectionStateRef.set(ConnectionState.CLOSED);
            }
        }
    }

    private void write(byte[] buffer) throws IOException {
        this.idleMilliseconds.set(0L);
        this.socket.getOutputStream().write(buffer);
    }

    private byte[] read() throws IOException, WebSocketException {
        byte[] availableArray;
        do {
            if ((availableArray = this.extractFrame()) != null) {
                return availableArray;
            }
            do {
                int bytesRead;
                if ((bytesRead = this.socket.getInputStream().read(this.rawBuffer)) < 0) continue;
                this.byteArrayIOStream.asOutputStream().write(this.rawBuffer, 0, bytesRead);
            } while (this.socket.getInputStream().available() > 0);
        } while ((availableArray = this.extractFrame()) == null);
        return availableArray;
    }

    private byte[] extractFrame() throws IOException {
        int availableBytes = this.byteArrayIOStream.asInputStream().available();
        if (this.connectionStateRef.get().equals((Object)ConnectionState.CONNECTING)) {
            if (availableBytes > 0) {
                return this.byteArrayIOStream.asInputStream().readAvailable();
            }
        } else if (availableBytes >= 2) {
            int required = 0;
            byte length = (byte)(this.byteArrayIOStream.asInputStream().peek(1) & 0x7F);
            if (length < 126) {
                required = length + 2;
            } else if (length == 126 && availableBytes >= 4) {
                required = ((this.byteArrayIOStream.asInputStream().peek(2) & 0xFF) << 8) + (this.byteArrayIOStream.asInputStream().peek(3) & 0xFF) + 4;
            } else if (availableBytes >= 10) {
                required = ((this.byteArrayIOStream.asInputStream().peek(6) & 0xFF) << 24) + ((this.byteArrayIOStream.asInputStream().peek(7) & 0xFF) << 16) + ((this.byteArrayIOStream.asInputStream().peek(8) & 0xFF) << 8) + (this.byteArrayIOStream.asInputStream().peek(9) & 0xFF) + 10;
            }
            if (required > 0 && availableBytes >= required) {
                byte[] outputArray = new byte[required];
                this.byteArrayIOStream.asInputStream().read(outputArray);
                return outputArray;
            }
        }
        return null;
    }

    public int getProtocolVersion() {
        return 13;
    }

    public String getNegotiatedProtocol() {
        return this.handshakeResponse.getProtocol();
    }

    public boolean isSecure() {
        return this.secure;
    }

    public URI getUri() {
        return this.uri;
    }

    public String url() {
        return this.url;
    }

    public ConnectionState getConnectionState() {
        return this.connectionStateRef.get();
    }

    public int connectionState() {
        return this.connectionStateRef.get().ordinal();
    }

    public String extensions() {
        return HandshakeResponse.getExtensionsAsString(this.handshakeResponse.getExtensions());
    }

    public int getMaxBinaryBufferSize() {
        return this.maxBinaryBufferSize.get();
    }

    public void setMaxBinaryBufferSize(int size) {
        this.maxBinaryBufferSize.set(size);
    }

    public int getMaxTextBufferSize() {
        return this.maxTextBufferSize.get();
    }

    public void setMaxTextBufferSize(int size) {
        this.maxTextBufferSize.set(size);
    }

    public long getMaxIdleTimeoutMilliseconds() {
        return this.maxIdleTimeoutMilliseconds.get();
    }

    public void setMaxIdleTimeoutMilliseconds(long milliseconds) {
        this.maxIdleTimeoutMilliseconds.set(milliseconds);
    }

    static /* synthetic */ byte[] access$100(WebSocket x0) throws IOException, WebSocketException {
        return x0.read();
    }

    static /* synthetic */ AtomicLong access$200(WebSocket x0) {
        return x0.idleMilliseconds;
    }

    static /* synthetic */ AtomicInteger access$300(WebSocket x0) {
        return x0.maxTextBufferSize;
    }

    static /* synthetic */ Socket access$400(WebSocket x0) {
        return x0.socket;
    }

    static /* synthetic */ ConcurrentLinkedQueue access$500(WebSocket x0) {
        return x0.pingKeyQueue;
    }

    static /* synthetic */ AtomicLong access$600(WebSocket x0) {
        return x0.maxIdleTimeoutMilliseconds;
    }

    private class MessageWorker
    implements Runnable {
        private CountDownLatch exitLatch = new CountDownLatch(1);
        private AtomicBoolean aborted = new AtomicBoolean(false);
        private LinkedList<Fragment> fragmentList = new LinkedList();

        private MessageWorker() {
        }

        public void abort() throws InterruptedException {
            if (this.aborted.compareAndSet(false, true)) {
                // empty if block
            }
            this.exitLatch.await();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try lbl-1000:
            // 19 sources

            {
                block23: while (!this.aborted.get()) {
                    try {
                        fragment = Frame.decode(WebSocket.access$100(WebSocket.this));
                        if (fragment.isFinal()) {
                            WebSocket.access$200(WebSocket.this).set(0L);
                            switch (1.$SwitchMap$org$smallmind$web$websocket$OpCode[fragment.getOpCode().ordinal()]) {
                                case 3: {
                                    if (this.fragmentList.isEmpty()) {
                                        throw new WebSocketException("No continuation exists to terminate", new Object[0]);
                                    }
                                    try {
                                        fragmentStream = new ByteArrayOutputStream();
                                        for (Fragment storedFragment : this.fragmentList) {
                                            fragmentStream.write(storedFragment.getMessage());
                                        }
                                        fragmentStream.write(fragment.getMessage());
                                        fragmentStream.close();
                                        switch (1.$SwitchMap$org$smallmind$web$websocket$OpCode[this.fragmentList.getFirst().getOpCode().ordinal()]) {
                                            case 1: {
                                                asString = new String(fragmentStream.toByteArray());
                                                if (asString.length() > WebSocket.access$300(WebSocket.this).get()) {
                                                    WebSocket.this.close(CloseCode.MESSAGE_TOO_LARGE, "exceeded maximum text buffer size");
                                                    ** break;
                                                }
                                                WebSocket.this.onText(asString);
                                                ** break;
                                            }
                                            case 2: {
                                                if (fragmentStream.size() > WebSocket.access$300(WebSocket.this).get()) {
                                                    WebSocket.this.close(CloseCode.MESSAGE_TOO_LARGE, "exceeded maximum binary buffer size");
                                                    ** break;
                                                }
                                                WebSocket.this.onBinary(fragmentStream.toByteArray());
                                                ** break;
                                            }
                                        }
                                        throw new WebSocketException("The current continuation starts with an illegal op code(%s)", new Object[]{this.fragmentList.getFirst().getOpCode().name()});
                                    }
                                    finally {
                                        this.fragmentList.clear();
                                        continue block23;
                                    }
                                }
                                case 1: {
                                    if (!this.fragmentList.isEmpty()) {
                                        this.fragmentList.clear();
                                        throw new WebSocketException("Expecting the final frame of a continuation", new Object[0]);
                                    }
                                    asString = new String(fragment.getMessage());
                                    if (asString.length() > WebSocket.access$300(WebSocket.this).get()) {
                                        WebSocket.this.close(CloseCode.MESSAGE_TOO_LARGE, "exceeded maximum text buffer size");
                                        continue block23;
                                    }
                                    WebSocket.this.onText(asString);
                                    continue block23;
                                }
                                case 2: {
                                    if (!this.fragmentList.isEmpty()) {
                                        this.fragmentList.clear();
                                        throw new WebSocketException("Expecting the final frame of a continuation", new Object[0]);
                                    }
                                    if (fragment.getMessage().length > WebSocket.access$300(WebSocket.this).get()) {
                                        WebSocket.this.close(CloseCode.MESSAGE_TOO_LARGE, "exceeded maximum binary buffer size");
                                        continue block23;
                                    }
                                    WebSocket.this.onBinary(fragment.getMessage());
                                    continue block23;
                                }
                                case 4: {
                                    if (fragment.getMessage().length < 2) {
                                        WebSocket.this.close(CloseCode.SERVER_ERROR, null);
                                        continue block23;
                                    }
                                    status = new byte[2];
                                    System.arraycopy(fragment.getMessage(), 0, status, 0, 2);
                                    WebSocket.this.close(CloseCode.fromBytes(status), null);
                                    continue block23;
                                }
                                case 5: {
                                    WebSocket.access$400(WebSocket.this).getOutputStream().write(Frame.pong(fragment.getMessage()));
                                    continue block23;
                                }
                                case 6: {
                                    pingKeyIter = WebSocket.access$500(WebSocket.this).iterator();
                                    pongKey = Base64Codec.encode((byte[])EncryptionUtility.hash((HashAlgorithm)HashAlgorithm.SHA_1, (byte[])fragment.getMessage()));
                                    while (pingKeyIter.hasNext()) {
                                        pingKey = (String)pingKeyIter.next();
                                        pingKeyIter.remove();
                                        if (!pongKey.equals(pingKey)) continue;
                                        WebSocket.this.onPong(fragment.getMessage());
                                        continue block23;
                                    }
                                    continue block23;
                                }
                            }
                            throw new UnknownSwitchCaseException(fragment.getOpCode().name(), new Object[0]);
                        }
                        if (!(fragment.getOpCode().equals((Object)OpCode.CONTINUATION) || fragment.getOpCode().equals((Object)OpCode.TEXT) || fragment.getOpCode().equals((Object)OpCode.BINARY))) {
                            throw new WebSocketException("All control frames must be marked as final", new Object[0]);
                        }
                        if ((fragment.getOpCode().equals((Object)OpCode.TEXT) || fragment.getOpCode().equals((Object)OpCode.BINARY)) && !this.fragmentList.isEmpty()) {
                            this.fragmentList.clear();
                            throw new WebSocketException("Starting a new continuation before the previous continuation has terminated", new Object[0]);
                        }
                        if (fragment.getOpCode().equals((Object)OpCode.CONTINUATION) && this.fragmentList.isEmpty()) {
                            throw new WebSocketException("The first frame of a continuation must have an op code != 0", new Object[0]);
                        }
                        this.fragmentList.add(fragment);
                    }
                    catch (SocketTimeoutException socketTimeoutException) {
                        idleTimeoutMilliseconds = WebSocket.access$600(WebSocket.this).get();
                        if (idleTimeoutMilliseconds <= 0L || WebSocket.access$200(WebSocket.this).addAndGet(1000L) < idleTimeoutMilliseconds) continue;
                        try {
                            WebSocket.this.close(CloseCode.GOING_AWAY, "max idle timeout exceeded");
                        }
                        catch (Exception exception) {
                            WebSocket.this.onError(exception);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        WebSocket.this.onError(exception);
                    }
                }
                return;
            }
            finally {
                this.exitLatch.countDown();
            }
        }
    }
}

