/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.web.websocket.spi;

import java.nio.ByteBuffer;
import javax.websocket.DecodeException;
import javax.websocket.Decoder;
import javax.websocket.Endpoint;
import javax.websocket.MessageHandler;
import javax.websocket.Session;
import org.smallmind.web.websocket.spi.SessionImpl;

public class DecodedByteBufferHandler<T>
implements MessageHandler.Whole<ByteBuffer> {
    private SessionImpl session;
    private Endpoint endpoint;
    private Decoder.Binary<T> decoder;
    private MessageHandler.Whole<T> handler;

    public DecodedByteBufferHandler(SessionImpl session, Endpoint endpoint, Decoder.Binary<T> decoder, MessageHandler.Whole<T> handler) {
        this.session = session;
        this.endpoint = endpoint;
        this.decoder = decoder;
        this.handler = handler;
    }

    public void onMessage(ByteBuffer message) {
        try {
            if (this.decoder.willDecode(message)) {
                this.handler.onMessage(this.decoder.decode(message));
            }
        }
        catch (DecodeException decodeException) {
            this.endpoint.onError((Session)this.session, (Throwable)decodeException);
        }
    }
}

