/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.web.websocket.spi;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.websocket.EncodeException;
import javax.websocket.Encoder;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.RemoteEndpoint;
import javax.websocket.SendHandler;
import javax.websocket.SendResult;
import javax.websocket.Session;
import org.smallmind.web.websocket.WebSocket;
import org.smallmind.web.websocket.WebSocketException;
import org.smallmind.web.websocket.spi.EncoderBinaryHandler;
import org.smallmind.web.websocket.spi.EncoderBinaryStreamHandler;
import org.smallmind.web.websocket.spi.EncoderHandler;
import org.smallmind.web.websocket.spi.EncoderTextHandler;
import org.smallmind.web.websocket.spi.EncoderTextStreamHandler;
import org.smallmind.web.websocket.spi.GenericParameterUtility;
import org.smallmind.web.websocket.spi.SessionImpl;

public class RemoteEndpointImpl
implements RemoteEndpoint {
    private final SessionImpl session;
    private final WebSocket webSocket;
    private final Endpoint endpoint;
    private final HashMap<Class<?>, EncoderHandler<?>> encoderHandlerMap = new HashMap();

    public RemoteEndpointImpl(SessionImpl session, WebSocket webSocket, Endpoint endpoint, EndpointConfig endpointConfig) {
        this.session = session;
        this.webSocket = webSocket;
        this.endpoint = endpoint;
        HashMap<Class, Encoder> encoderInstanceMap = new HashMap<Class, Encoder>();
        for (Class encoderClass : endpointConfig.getEncoders()) {
            Encoder encoder;
            if (Encoder.Text.class.isAssignableFrom(encoderClass)) {
                encoder = (Encoder)encoderInstanceMap.get(encoderClass);
                if (encoder == null) {
                    try {
                        encoder = (Encoder)encoderClass.newInstance();
                        encoderInstanceMap.put(encoderClass, encoder);
                    }
                    catch (IllegalAccessException | InstantiationException exception) {
                        endpoint.onError((Session)session, (Throwable)exception);
                    }
                }
                this.encoderHandlerMap.put(GenericParameterUtility.getTypeParameter(encoderClass, Encoder.Text.class), new EncoderTextHandler((Encoder.Text)encoder));
            }
            if (Encoder.TextStream.class.isAssignableFrom(encoderClass)) {
                encoder = (Encoder)encoderInstanceMap.get(encoderClass);
                if (encoder == null) {
                    try {
                        encoder = (Encoder)encoderClass.newInstance();
                        encoderInstanceMap.put(encoderClass, encoder);
                    }
                    catch (IllegalAccessException | InstantiationException exception) {
                        endpoint.onError((Session)session, (Throwable)exception);
                    }
                }
                this.encoderHandlerMap.put(GenericParameterUtility.getTypeParameter(encoderClass, Encoder.TextStream.class), new EncoderTextStreamHandler((Encoder.TextStream)encoder));
            }
            if (Encoder.Binary.class.isAssignableFrom(encoderClass)) {
                encoder = (Encoder)encoderInstanceMap.get(encoderClass);
                if (encoder == null) {
                    try {
                        encoder = (Encoder)encoderClass.newInstance();
                        encoderInstanceMap.put(encoderClass, encoder);
                    }
                    catch (IllegalAccessException | InstantiationException exception) {
                        endpoint.onError((Session)session, (Throwable)exception);
                    }
                }
                this.encoderHandlerMap.put(GenericParameterUtility.getTypeParameter(encoderClass, Encoder.Binary.class), new EncoderBinaryHandler((Encoder.Binary)encoder));
            }
            if (!Encoder.BinaryStream.class.isAssignableFrom(encoderClass)) continue;
            encoder = (Encoder)encoderInstanceMap.get(encoderClass);
            if (encoder == null) {
                try {
                    encoder = (Encoder)encoderClass.newInstance();
                    encoderInstanceMap.put(encoderClass, encoder);
                }
                catch (IllegalAccessException | InstantiationException exception) {
                    endpoint.onError((Session)session, (Throwable)exception);
                }
            }
            this.encoderHandlerMap.put(GenericParameterUtility.getTypeParameter(encoderClass, Encoder.BinaryStream.class), new EncoderBinaryStreamHandler((Encoder.BinaryStream)encoder));
        }
    }

    public SessionImpl getSession() {
        return this.session;
    }

    public WebSocket getWebSocket() {
        return this.webSocket;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public HashMap<Class<?>, EncoderHandler<?>> getEncoderHandlerMap() {
        return this.encoderHandlerMap;
    }

    public boolean getBatchingAllowed() {
        return false;
    }

    public void setBatchingAllowed(boolean allowed) {
    }

    public void flushBatch() {
    }

    public void sendPing(ByteBuffer applicationData) throws IOException {
        try {
            this.webSocket.ping(applicationData.array());
        }
        catch (WebSocketException webSocketException) {
            this.endpoint.onError((Session)this.session, (Throwable)((Object)webSocketException));
        }
    }

    public void sendPong(ByteBuffer applicationData) throws IOException {
        throw new IOException("pongs are automatically sent in response to pings");
    }

    private abstract class SendExecutable {
        private SendExecutable() {
        }

        public abstract void execute() throws Throwable;
    }

    private class SendRunnable
    implements Runnable {
        private SendExecutable executable;
        private Throwable throwable;

        public SendRunnable(SendExecutable executable) {
            this.executable = executable;
        }

        public Throwable getThrowable() {
            return this.throwable;
        }

        @Override
        public void run() {
            try {
                this.executable.execute();
            }
            catch (Throwable throwable) {
                this.throwable = throwable;
            }
        }
    }

    private class SendFuture
    implements Future<Void> {
        private SendRunnable sendRunnable;
        private Thread sendThread;

        public SendFuture(SendRunnable sendRunnable) {
            this.sendRunnable = sendRunnable;
            this.sendThread = new Thread(sendRunnable);
            this.sendThread.start();
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return !this.sendThread.isAlive();
        }

        @Override
        public Void get() throws InterruptedException, ExecutionException {
            this.sendThread.join();
            if (this.sendRunnable.getThrowable() != null) {
                throw new ExecutionException(this.sendRunnable.getThrowable());
            }
            return null;
        }

        @Override
        public Void get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            this.sendThread.join(unit.toMillis(timeout));
            if (this.sendThread.isAlive()) {
                throw new TimeoutException();
            }
            if (this.sendRunnable.getThrowable() != null) {
                throw new ExecutionException(this.sendRunnable.getThrowable());
            }
            return null;
        }
    }

    private class SendWriter
    extends Writer {
        private Basic basicEndpoint;
        private AtomicReference<StringBuilder> partialBuilderRef;

        public SendWriter(Basic basicEndpoint, AtomicReference<StringBuilder> partialBuilderRef) {
            this.basicEndpoint = basicEndpoint;
            this.partialBuilderRef = partialBuilderRef;
        }

        @Override
        public void write(char[] cbuf, int off, int len) {
            this.partialBuilderRef.get().append(cbuf, off, len);
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() throws IOException {
            String completeText = this.partialBuilderRef.get().toString();
            this.partialBuilderRef.set(null);
            this.basicEndpoint.sendText(completeText);
        }
    }

    private class SendStream
    extends OutputStream {
        private Basic basicEndpoint;
        private AtomicReference<ByteArrayOutputStream> partialStreamRef;

        public SendStream(Basic basicEndpoint, AtomicReference<ByteArrayOutputStream> partialStreamRef) {
            this.basicEndpoint = basicEndpoint;
            this.partialStreamRef = partialStreamRef;
        }

        @Override
        public void write(int b) {
            this.partialStreamRef.get().write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) {
            this.partialStreamRef.get().write(b, off, len);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.partialStreamRef.get().write(b);
        }

        @Override
        public void close() throws IOException {
            byte[] completeBuffer = this.partialStreamRef.get().toByteArray();
            this.partialStreamRef.set(null);
            this.basicEndpoint.sendBinary(ByteBuffer.wrap(completeBuffer));
            super.close();
        }
    }

    public static class Async
    extends RemoteEndpointImpl
    implements RemoteEndpoint.Async {
        private AtomicLong sendTimeout;

        public Async(SessionImpl session, WebSocket webSocket, Endpoint endpoint, EndpointConfig endpointConfig) {
            super(session, webSocket, endpoint, endpointConfig);
            this.sendTimeout = new AtomicLong(session.getContainer().getDefaultAsyncSendTimeout());
        }

        public synchronized long getSendTimeout() {
            return this.sendTimeout.get();
        }

        public synchronized void setSendTimeout(long timeoutmillis) {
            this.sendTimeout.set(timeoutmillis);
        }

        public Future<Void> sendText(final String text) {
            return new SendFuture(new SendRunnable(new SendExecutable(){

                @Override
                public void execute() throws IOException {
                    try {
                        this.getWebSocket().text(text);
                    }
                    catch (WebSocketException webSocketException) {
                        this.getEndpoint().onError((Session)this.getSession(), (Throwable)((Object)webSocketException));
                    }
                }
            }));
        }

        public void sendText(String text, SendHandler handler) {
            this.waitForFuture(this.sendText(text), handler);
        }

        public Future<Void> sendBinary(final ByteBuffer data) {
            return new SendFuture(new SendRunnable(new SendExecutable(){

                @Override
                public void execute() throws IOException {
                    try {
                        this.getWebSocket().binary(data.array());
                    }
                    catch (WebSocketException webSocketException) {
                        this.getEndpoint().onError((Session)this.getSession(), (Throwable)((Object)webSocketException));
                    }
                }
            }));
        }

        public void sendBinary(ByteBuffer data, SendHandler handler) {
            this.waitForFuture(this.sendBinary(data), handler);
        }

        public Future<Void> sendObject(final Object data) {
            return new SendFuture(new SendRunnable(new SendExecutable(){

                @Override
                public void execute() throws IOException, EncodeException {
                    try {
                        EncoderHandler<?> encoderHandler = this.getEncoderHandlerMap().get(data.getClass());
                        if (encoderHandler != null) {
                            this.getWebSocket().binary(encoderHandler.encode(data));
                        } else {
                            this.getWebSocket().text(data.toString());
                        }
                    }
                    catch (WebSocketException webSocketException) {
                        this.getEndpoint().onError((Session)this.getSession(), (Throwable)((Object)webSocketException));
                    }
                }
            }));
        }

        public void sendObject(Object data, SendHandler handler) {
            this.waitForFuture(this.sendObject(data), handler);
        }

        private void waitForFuture(Future<Void> future, SendHandler handler) {
            try {
                long sendTimeout = this.getSendTimeout();
                if (sendTimeout > 0L) {
                    future.get(sendTimeout, TimeUnit.MILLISECONDS);
                } else {
                    future.get();
                }
                handler.onResult(new SendResult());
            }
            catch (InterruptedException | ExecutionException | TimeoutException exception) {
                handler.onResult(new SendResult((Throwable)exception));
            }
        }
    }

    public static class Basic
    extends RemoteEndpointImpl
    implements RemoteEndpoint.Basic {
        private AtomicReference<StringBuilder> partialBuilderRef = new AtomicReference();
        private AtomicReference<ByteArrayOutputStream> partialStreamRef = new AtomicReference();

        public Basic(SessionImpl session, WebSocket webSocket, Endpoint endpoint, EndpointConfig endpointConfig) {
            super(session, webSocket, endpoint, endpointConfig);
        }

        public synchronized void sendText(String text) throws IOException {
            if (this.partialBuilderRef.get() != null || this.partialStreamRef.get() != null) {
                throw new IllegalStateException("Incomplete transmission ongoing in another thread of execution");
            }
            try {
                this.getWebSocket().text(text);
            }
            catch (WebSocketException webSocketException) {
                this.getEndpoint().onError((Session)this.getSession(), (Throwable)((Object)webSocketException));
            }
        }

        public synchronized void sendBinary(ByteBuffer data) throws IOException {
            if (this.partialBuilderRef.get() != null || this.partialStreamRef.get() != null) {
                throw new IllegalStateException("Incomplete transmission ongoing in another thread of execution");
            }
            try {
                this.getWebSocket().binary(data.array());
            }
            catch (WebSocketException webSocketException) {
                this.getEndpoint().onError((Session)this.getSession(), (Throwable)((Object)webSocketException));
            }
        }

        public synchronized void sendText(String partialMessage, boolean isLast) throws IOException {
            if (this.partialStreamRef.get() != null) {
                throw new IllegalStateException("Incomplete transmission ongoing in another thread of execution");
            }
            if (isLast) {
                if (this.partialBuilderRef.get() == null) {
                    this.sendText(partialMessage);
                } else {
                    String completeText = this.partialBuilderRef.get().append(partialMessage).toString();
                    this.partialBuilderRef.set(null);
                    this.sendText(completeText);
                }
            } else {
                StringBuilder partialBuilder = this.partialBuilderRef.get();
                if (partialBuilder == null) {
                    partialBuilder = new StringBuilder();
                    this.partialBuilderRef.set(partialBuilder);
                }
                partialBuilder.append(partialMessage);
            }
        }

        public synchronized void sendBinary(ByteBuffer partialByte, boolean isLast) throws IOException {
            if (this.partialBuilderRef.get() != null) {
                throw new IllegalStateException("Incomplete transmission ongoing in another thread of execution");
            }
            if (isLast) {
                if (this.partialStreamRef.get() == null) {
                    this.sendBinary(partialByte);
                } else {
                    this.partialStreamRef.get().write(partialByte.array());
                    byte[] completeBuffer = this.partialStreamRef.get().toByteArray();
                    this.partialStreamRef.set(null);
                    this.sendBinary(ByteBuffer.wrap(completeBuffer));
                }
            } else {
                ByteArrayOutputStream partialStream = this.partialStreamRef.get();
                if (partialStream == null) {
                    partialStream = new ByteArrayOutputStream();
                    this.partialStreamRef.set(partialStream);
                }
                partialStream.write(partialByte.array());
            }
        }

        public synchronized OutputStream getSendStream() throws IOException {
            if (this.partialBuilderRef.get() != null || this.partialStreamRef.get() != null) {
                throw new IllegalStateException("Incomplete transmission ongoing in another thread of execution");
            }
            this.partialStreamRef.set(new ByteArrayOutputStream());
            return new SendStream(this, this.partialStreamRef);
        }

        public synchronized Writer getSendWriter() throws IOException {
            if (this.partialBuilderRef.get() != null || this.partialStreamRef.get() != null) {
                throw new IllegalStateException("Incomplete transmission ongoing in another thread of execution");
            }
            this.partialBuilderRef.set(new StringBuilder());
            return new SendWriter(this, this.partialBuilderRef);
        }

        public void sendObject(Object data) throws IOException, EncodeException {
            EncoderHandler<?> encoderHandler = this.getEncoderHandlerMap().get(data.getClass());
            if (encoderHandler != null) {
                this.sendBinary(ByteBuffer.wrap(encoderHandler.encode(data)));
            } else {
                this.sendText(data.toString());
            }
        }
    }
}

