/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.web.websocket.spi;

import java.io.IOException;
import java.net.URI;
import java.security.NoSuchAlgorithmException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.Extension;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import org.smallmind.web.websocket.WebSocketException;
import org.smallmind.web.websocket.spi.AnnotatedEndpoint;
import org.smallmind.web.websocket.spi.SessionImpl;

public class WebSocketContainerImpl
implements WebSocketContainer {
    private final AtomicLong defaultMaxSessionIdleTimeout = new AtomicLong(-1L);
    private final AtomicInteger defaultMaxTextMessageBufferSize = new AtomicInteger(Integer.MAX_VALUE);
    private final AtomicInteger defaultMaxBinaryMessageBufferSize = new AtomicInteger(Integer.MAX_VALUE);
    private AtomicLong defaultAsyncSendTimeout = new AtomicLong(-1L);

    public Session connectToServer(Class<?> annotatedEndpointClass, URI path) throws DeploymentException, IOException {
        AnnotatedEndpoint annotatedEndpoint = new AnnotatedEndpoint(annotatedEndpointClass);
        try {
            return new SessionImpl(this, path, annotatedEndpoint, annotatedEndpoint.getEndpointConfig());
        }
        catch (NoSuchAlgorithmException | WebSocketException exception) {
            throw new DeploymentException("Unable to instantiate a connection", (Throwable)exception);
        }
    }

    public Session connectToServer(Object annotatedEndpointInstance, URI path) throws DeploymentException, IOException {
        AnnotatedEndpoint annotatedEndpoint = new AnnotatedEndpoint(annotatedEndpointInstance.getClass());
        try {
            return new SessionImpl(this, path, annotatedEndpoint, annotatedEndpoint.getEndpointConfig());
        }
        catch (NoSuchAlgorithmException | WebSocketException exception) {
            throw new DeploymentException("Unable to instantiate a connection", (Throwable)exception);
        }
    }

    public Session connectToServer(Class<? extends Endpoint> endpointClass, ClientEndpointConfig cec, URI path) throws DeploymentException, IOException {
        try {
            return new SessionImpl(this, path, endpointClass.newInstance(), cec);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchAlgorithmException | WebSocketException exception) {
            throw new DeploymentException("Unable to instantiate a connection", (Throwable)exception);
        }
    }

    public Session connectToServer(Endpoint endpointInstance, ClientEndpointConfig cec, URI path) throws DeploymentException, IOException {
        try {
            return new SessionImpl(this, path, endpointInstance, cec);
        }
        catch (NoSuchAlgorithmException | WebSocketException exception) {
            throw new DeploymentException("Unable to instantiate a connection", (Throwable)exception);
        }
    }

    public long getDefaultAsyncSendTimeout() {
        return this.defaultAsyncSendTimeout.get();
    }

    public void setAsyncSendTimeout(long timeoutmillis) {
        this.defaultAsyncSendTimeout.set(timeoutmillis);
    }

    public long getDefaultMaxSessionIdleTimeout() {
        return this.defaultMaxSessionIdleTimeout.get();
    }

    public void setDefaultMaxSessionIdleTimeout(long timeout) {
        this.defaultMaxSessionIdleTimeout.set(timeout);
    }

    public int getDefaultMaxBinaryMessageBufferSize() {
        return this.defaultMaxBinaryMessageBufferSize.get();
    }

    public void setDefaultMaxBinaryMessageBufferSize(int max) {
        this.defaultMaxBinaryMessageBufferSize.set(max);
    }

    public int getDefaultMaxTextMessageBufferSize() {
        return this.defaultMaxTextMessageBufferSize.get();
    }

    public void setDefaultMaxTextMessageBufferSize(int max) {
        this.defaultMaxTextMessageBufferSize.set(max);
    }

    public Set<Extension> getInstalledExtensions() {
        return null;
    }
}

