/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.api.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.util.List;
import java.util.Properties;
import javax.annotation.Nullable;
import org.sonarsource.scanner.api.internal.batch.IsolatedLauncher;
import org.sonarsource.scanner.api.internal.batch.LogOutput;
import org.sonarsource.scanner.api.internal.cache.Logger;

public class SimulatedLauncher
implements IsolatedLauncher {
    private final String version;
    private final Logger logger;
    private Properties globalProperties;

    SimulatedLauncher(String version, Logger logger) {
        this.version = version;
        this.logger = logger;
    }

    @Override
    public void start(Properties properties, LogOutput logOutput) {
        this.globalProperties = properties;
    }

    @Override
    public void stop() {
        this.globalProperties = null;
    }

    @Override
    public void execute(Properties properties) {
        this.dumpProperties(this.globalProperties, properties);
    }

    private void dumpProperties(@Nullable Properties global, Properties analysis) {
        String filePath;
        String filePathGlobal = null;
        if (global != null) {
            filePath = global.getProperty("sonar.scanner.dumpToFile", global.getProperty("sonarRunner.dumpToFile"));
            filePathGlobal = filePath + ".global";
        } else {
            filePath = analysis.getProperty("sonar.scanner.dumpToFile", analysis.getProperty("sonarRunner.dumpToFile"));
        }
        if (filePath == null) {
            throw new IllegalStateException("No file to dump properties");
        }
        if (global != null) {
            File dumpFileGlobal = new File(filePathGlobal);
            SimulatedLauncher.writeProperties(dumpFileGlobal, global, "global properties");
        }
        File dumpFile = new File(filePath);
        SimulatedLauncher.writeProperties(dumpFile, analysis, "analysis properties");
        this.logger.info("Simulation mode. Configuration written to " + dumpFile.getAbsolutePath());
    }

    private static void writeProperties(File outputFile, Properties p, String comment) {
        try (FileOutputStream output = new FileOutputStream(outputFile);){
            p.store(output, "Generated by sonar-runner - " + comment);
        }
        catch (Exception e) {
            throw new IllegalStateException("Fail to export sonar-runner properties", e);
        }
    }

    @Override
    public void executeOldVersion(Properties properties, List<Object> extensions) {
        this.dumpProperties(null, properties);
    }

    @Override
    public String getVersion() {
        return this.version;
    }
}

