/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.jdiff;

import java.io.File;
import java.io.IOException;
import java.util.Locale;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.SinkFactory;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.MavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.spf4j.jdiff.BaseJDiffMojo;
import org.spf4j.jdiff.JDiffRunner;
import org.spf4j.jdiff.JavadocExecutionException;

@Mojo(name="jdiff", requiresDependencyResolution=ResolutionScope.COMPILE)
@Execute(phase=LifecyclePhase.VERIFY)
public final class ApiChangesMojo
extends BaseJDiffMojo
implements MavenReport {
    @Parameter(property="versionRange", defaultValue="[,${project.version}]")
    private String versionRange;
    @Parameter(property="maxNumberOfDiffs", defaultValue="10")
    private int maxNumberOfDiffs;
    @Parameter(property="destDir", defaultValue="${project.reporting.outputDirectory}/apidocs")
    private File destDir;

    public String getCategoryName() {
        return "Project Reports";
    }

    public File getReportOutputDirectory() {
        return this.destDir;
    }

    public boolean canGenerateReport() {
        return !this.getCompileSourceRoots().isEmpty();
    }

    public String getOutputName() {
        return "apidocs/changes";
    }

    public String getName(Locale locale) {
        return "JDiff Reports";
    }

    public void generate(Sink aSink, SinkFactory aSinkFactory, Locale aLocale) throws MavenReportException {
        if (!this.canGenerateReport()) {
            this.getLog().info((CharSequence)"This report cannot be generated as part of the current build. The report name should be referenced in this line of output.");
            return;
        }
        try {
            this.execute();
        }
        catch (MojoExecutionException ex) {
            throw new MavenReportException("Failed to exec report: " + (Object)((Object)this), (Exception)((Object)ex));
        }
    }

    public void execute() throws MojoExecutionException {
        MavenProject mavenProject = this.getMavenProject();
        try {
            this.getLog().info((CharSequence)"Executing JDiff javadoc doclet");
            JDiffRunner runner = new JDiffRunner(this.getMojoExecution(), this.getToolchainManager(), this.getMavenSession(), this.getProjectRepos(), this.getRepoSystem(), this.getJavadocExecutable());
            runner.runDiffBetweenReleases(mavenProject.getGroupId(), mavenProject.getArtifactId(), this.versionRange, this.destDir, this.maxNumberOfDiffs);
            runner.writeChangesIndexHtml(this.destDir, "changes.html");
            this.getLog().info((CharSequence)("Generated " + this.destDir + File.separatorChar + "changes.html"));
        }
        catch (IOException | ArtifactResolutionException | DependencyResolutionException | VersionRangeResolutionException | JavadocExecutionException ex) {
            throw new MojoExecutionException("Failed executing mojo " + (Object)((Object)this), (Exception)ex);
        }
    }

    public void generate(org.codehaus.doxia.sink.Sink sink, Locale locale) throws MavenReportException {
        try {
            this.execute();
        }
        catch (MojoExecutionException ex) {
            throw new MavenReportException("Failed to exec report: " + (Object)((Object)this), (Exception)((Object)ex));
        }
    }

    public String getDescription(Locale locale) {
        return "API JDiff reports";
    }

    public void setReportOutputDirectory(File outputDirectory) {
        this.destDir = new File(outputDirectory, "apidocs");
    }

    public boolean isExternalReport() {
        return true;
    }

    @Override
    public String toString() {
        return "ApiChangesMojo{versionRange=" + this.versionRange + ", maxNumberOfDiffs=" + this.maxNumberOfDiffs + ", destDir=" + this.destDir + ", parent=" + super.toString() + '}';
    }
}

