/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.core;

import java.util.Arrays;
import org.springdoc.core.GroupedOpenApi;
import org.springdoc.core.SpecPropertiesCondition;
import org.springdoc.core.SpringDocConfiguration;
import org.springdoc.core.customizers.SpecPropertiesCustomizer;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.env.PropertyResolver;

@Lazy(value=false)
@Configuration(proxyBeanMethods=false)
@Conditional(value={SpecPropertiesCondition.class})
@ConditionalOnBean(value={SpringDocConfiguration.class})
public class SpringDocSpecPropertiesConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @Lazy(value=false)
    SpecPropertiesCustomizer specificationStringPropertiesCustomizer(PropertyResolver propertyResolverUtils) {
        return new SpecPropertiesCustomizer(propertyResolverUtils);
    }

    @Bean
    @ConditionalOnMissingBean
    @Lazy(value=false)
    SpecificationStringPropertiesCustomizerBeanPostProcessor specificationStringPropertiesCustomizerBeanPostProcessor(PropertyResolver propertyResolverUtils) {
        return new SpecificationStringPropertiesCustomizerBeanPostProcessor(propertyResolverUtils);
    }

    private static class SpecificationStringPropertiesCustomizerBeanPostProcessor
    implements BeanPostProcessor {
        private final PropertyResolver propertyResolverUtils;

        public SpecificationStringPropertiesCustomizerBeanPostProcessor(PropertyResolver propertyResolverUtils) {
            this.propertyResolverUtils = propertyResolverUtils;
        }

        public Object postProcessAfterInitialization(Object bean, String beanName) {
            if (bean instanceof GroupedOpenApi) {
                GroupedOpenApi groupedOpenApi = (GroupedOpenApi)bean;
                groupedOpenApi.addAllOpenApiCustomizer(Arrays.asList(new SpecPropertiesCustomizer(this.propertyResolverUtils, groupedOpenApi.getGroup())));
            }
            return bean;
        }
    }
}

