/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.webflux.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.v3.oas.annotations.Operation;
import java.util.List;
import java.util.Locale;
import org.springdoc.core.customizers.SpringDocCustomizers;
import org.springdoc.core.models.GroupedOpenApi;
import org.springdoc.core.properties.SpringDocConfigProperties;
import org.springdoc.core.providers.SpringDocProviders;
import org.springdoc.core.service.AbstractRequestService;
import org.springdoc.core.service.GenericResponseService;
import org.springdoc.core.service.OpenAPIService;
import org.springdoc.core.service.OperationService;
import org.springdoc.webflux.api.MultipleOpenApiResource;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.actuate.endpoint.web.annotation.RestControllerEndpoint;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import reactor.core.publisher.Mono;

@RestControllerEndpoint(id="openapi")
public class MultipleOpenApiActuatorResource
extends MultipleOpenApiResource {
    public MultipleOpenApiActuatorResource(List<GroupedOpenApi> groupedOpenApis, ObjectFactory<OpenAPIService> defaultOpenAPIBuilder, AbstractRequestService requestBuilder, GenericResponseService responseBuilder, OperationService operationParser, SpringDocConfigProperties springDocConfigProperties, SpringDocProviders springDocProviders, SpringDocCustomizers springDocCustomizers) {
        super(groupedOpenApis, defaultOpenAPIBuilder, requestBuilder, responseBuilder, operationParser, springDocConfigProperties, springDocProviders, springDocCustomizers);
    }

    @Operation(hidden=true)
    @GetMapping(value={"/{group}"}, produces={"application/json"})
    public Mono<byte[]> openapiJson(ServerHttpRequest serverHttpRequest, @Value(value="${springdoc.api-docs.path:#{T(org.springdoc.core.utils.Constants).DEFAULT_API_DOCS_URL}}") String apiDocsUrl, @PathVariable String group, Locale locale) throws JsonProcessingException {
        return this.getOpenApiResourceOrThrow(group).openapiJson(serverHttpRequest, apiDocsUrl + "/" + group, locale);
    }

    @Operation(hidden=true)
    @GetMapping(value={"/{group}/yaml"}, produces={"application/vnd.oai.openapi"})
    public Mono<byte[]> openapiYaml(ServerHttpRequest serverHttpRequest, @Value(value="${springdoc.api-docs.path:#{T(org.springdoc.core.utils.Constants).DEFAULT_API_DOCS_URL}}.yaml") String apiDocsUrl, @PathVariable String group, Locale locale) throws JsonProcessingException {
        return this.getOpenApiResourceOrThrow(group).openapiYaml(serverHttpRequest, apiDocsUrl + "/" + group, locale);
    }
}

