/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.autoconfigure.mcp.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.modelcontextprotocol.client.McpSyncClient;
import io.modelcontextprotocol.client.transport.HttpClientSseClientTransport;
import io.modelcontextprotocol.spec.ClientMcpTransport;
import io.modelcontextprotocol.spec.McpSchema;
import java.net.http.HttpClient;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.ai.autoconfigure.mcp.client.NamedClientMcpTransport;
import org.springframework.ai.autoconfigure.mcp.client.SseWebFluxTransportAutoConfiguration;
import org.springframework.ai.autoconfigure.mcp.client.properties.McpClientCommonProperties;
import org.springframework.ai.autoconfigure.mcp.client.properties.McpSseClientProperties;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(after={SseWebFluxTransportAutoConfiguration.class})
@ConditionalOnClass(value={McpSchema.class, McpSyncClient.class})
@ConditionalOnMissingClass(value={"io.modelcontextprotocol.client.transport.public class WebFluxSseClientTransport"})
@EnableConfigurationProperties(value={McpSseClientProperties.class, McpClientCommonProperties.class})
@ConditionalOnProperty(prefix="spring.ai.mcp.client", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class SseHttpClientTransportAutoConfiguration {
    @Bean
    public List<NamedClientMcpTransport> mcpHttpClientTransports(McpSseClientProperties sseProperties, ObjectMapper objectMapper) {
        ArrayList<NamedClientMcpTransport> sseTransports = new ArrayList<NamedClientMcpTransport>();
        for (Map.Entry<String, McpSseClientProperties.SseParameters> serverParameters : sseProperties.getConnections().entrySet()) {
            HttpClientSseClientTransport transport = new HttpClientSseClientTransport(HttpClient.newBuilder(), serverParameters.getValue().url(), objectMapper);
            sseTransports.add(new NamedClientMcpTransport(serverParameters.getKey(), (ClientMcpTransport)transport));
        }
        return sseTransports;
    }

    @Bean
    @ConditionalOnMissingBean
    public ObjectMapper objectMapper() {
        return new ObjectMapper();
    }
}

