/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.model.function;

import com.fasterxml.jackson.annotation.JsonClassDescription;
import java.lang.reflect.Type;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import org.springframework.ai.chat.model.ToolContext;
import org.springframework.ai.model.function.FunctionCallback;
import org.springframework.ai.model.function.FunctionCallbackResolver;
import org.springframework.ai.tool.resolution.TypeResolverHelper;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Description;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.KotlinDetector;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.ResolvableType;
import org.springframework.lang.NonNull;
import org.springframework.util.StringUtils;

@Deprecated
public class DefaultFunctionCallbackResolver
implements ApplicationContextAware,
FunctionCallbackResolver {
    private GenericApplicationContext applicationContext;
    private FunctionCallback.SchemaType schemaType = FunctionCallback.SchemaType.JSON_SCHEMA;

    public void setSchemaType(FunctionCallback.SchemaType schemaType) {
        this.schemaType = schemaType;
    }

    public void setApplicationContext(@NonNull ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = (GenericApplicationContext)applicationContext;
    }

    @Override
    public FunctionCallback resolve(@NonNull String beanName) {
        ResolvableType functionType = TypeResolverHelper.resolveBeanType(this.applicationContext, beanName);
        ResolvableType functionInputType = ResolvableType.forType(Supplier.class).isAssignableFrom(functionType) ? ResolvableType.forType(Void.class) : TypeResolverHelper.getFunctionArgumentType(functionType, 0);
        String functionDescription = this.resolveFunctionDescription(beanName, functionInputType.toClass());
        Object bean = this.applicationContext.getBean(beanName);
        return this.buildFunctionCallback(beanName, functionType, functionInputType, functionDescription, bean);
    }

    private String resolveFunctionDescription(String beanName, Class<?> functionInputClass) {
        String functionDescription = "";
        if (!StringUtils.hasText((String)functionDescription)) {
            JsonClassDescription jsonClassDescriptionAnnotation;
            Description descriptionAnnotation = (Description)this.applicationContext.findAnnotationOnBean(beanName, Description.class);
            if (descriptionAnnotation != null) {
                functionDescription = descriptionAnnotation.value();
            }
            if (!StringUtils.hasText((String)functionDescription) && (jsonClassDescriptionAnnotation = functionInputClass.getAnnotation(JsonClassDescription.class)) != null) {
                functionDescription = jsonClassDescriptionAnnotation.value();
            }
            if (!StringUtils.hasText((String)functionDescription)) {
                throw new IllegalStateException("Could not determine function description. Please provide a description either as a default parameter, via @Description annotation on the bean or @JsonClassDescription annotation on the input class.");
            }
        }
        return functionDescription;
    }

    private FunctionCallback buildFunctionCallback(String beanName, ResolvableType functionType, ResolvableType functionInputType, String functionDescription, Object bean) {
        if (KotlinDetector.isKotlinPresent()) {
            if (KotlinDelegate.isKotlinFunction(functionType.toClass())) {
                return ((FunctionCallback.FunctionInvokingSpec)((FunctionCallback.FunctionInvokingSpec)FunctionCallback.builder().function(beanName, KotlinDelegate.wrapKotlinFunction(bean)).schemaType(this.schemaType)).description(functionDescription)).inputType(ParameterizedTypeReference.forType((Type)functionInputType.getType())).build();
            }
            if (KotlinDelegate.isKotlinBiFunction(functionType.toClass())) {
                return ((FunctionCallback.FunctionInvokingSpec)((FunctionCallback.FunctionInvokingSpec)FunctionCallback.builder().function(beanName, KotlinDelegate.wrapKotlinBiFunction(bean)).description(functionDescription)).schemaType(this.schemaType)).inputType(ParameterizedTypeReference.forType((Type)functionInputType.getType())).build();
            }
            if (KotlinDelegate.isKotlinSupplier(functionType.toClass())) {
                return ((FunctionCallback.FunctionInvokingSpec)((FunctionCallback.FunctionInvokingSpec)FunctionCallback.builder().function(beanName, KotlinDelegate.wrapKotlinSupplier(bean)).description(functionDescription)).schemaType(this.schemaType)).inputType(ParameterizedTypeReference.forType((Type)functionInputType.getType())).build();
            }
        }
        if (bean instanceof Function) {
            Function function = (Function)bean;
            return ((FunctionCallback.FunctionInvokingSpec)((FunctionCallback.FunctionInvokingSpec)FunctionCallback.builder().function(beanName, function).schemaType(this.schemaType)).description(functionDescription)).inputType(ParameterizedTypeReference.forType((Type)functionInputType.getType())).build();
        }
        if (bean instanceof BiFunction) {
            return ((FunctionCallback.FunctionInvokingSpec)((FunctionCallback.FunctionInvokingSpec)FunctionCallback.builder().function(beanName, (BiFunction)bean).description(functionDescription)).schemaType(this.schemaType)).inputType(ParameterizedTypeReference.forType((Type)functionInputType.getType())).build();
        }
        if (bean instanceof Supplier) {
            Supplier supplier = (Supplier)bean;
            return ((FunctionCallback.FunctionInvokingSpec)((FunctionCallback.FunctionInvokingSpec)FunctionCallback.builder().function(beanName, supplier).description(functionDescription)).schemaType(this.schemaType)).inputType(ParameterizedTypeReference.forType((Type)functionInputType.getType())).build();
        }
        if (bean instanceof Consumer) {
            Consumer consumer = (Consumer)bean;
            return ((FunctionCallback.FunctionInvokingSpec)((FunctionCallback.FunctionInvokingSpec)FunctionCallback.builder().function(beanName, consumer).description(functionDescription)).schemaType(this.schemaType)).inputType(ParameterizedTypeReference.forType((Type)functionInputType.getType())).build();
        }
        throw new IllegalStateException("Unsupported function type");
    }

    private static final class KotlinDelegate {
        private KotlinDelegate() {
        }

        public static boolean isKotlinSupplier(Class<?> clazz) {
            return Function0.class.isAssignableFrom(clazz);
        }

        public static Supplier<?> wrapKotlinSupplier(Object function) {
            return () -> ((Function0)function).invoke();
        }

        public static boolean isKotlinFunction(Class<?> clazz) {
            return Function1.class.isAssignableFrom(clazz);
        }

        public static Function<?, ?> wrapKotlinFunction(Object function) {
            return t -> ((Function1)function).invoke(t);
        }

        public static boolean isKotlinBiFunction(Class<?> clazz) {
            return Function2.class.isAssignableFrom(clazz);
        }

        public static BiFunction<?, ToolContext, ?> wrapKotlinBiFunction(Object function) {
            return (t, u) -> ((Function2)function).invoke(t, u);
        }
    }
}

