/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.model.tool;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.ai.chat.prompt.ChatOptions;
import org.springframework.ai.model.function.FunctionCallback;
import org.springframework.ai.model.function.FunctionCallingOptions;
import org.springframework.ai.model.tool.DefaultToolCallingChatOptions;
import org.springframework.ai.tool.util.ToolUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public interface ToolCallingChatOptions
extends FunctionCallingOptions {
    public static final boolean DEFAULT_TOOL_EXECUTION_ENABLED = true;

    public List<FunctionCallback> getToolCallbacks();

    public void setToolCallbacks(List<FunctionCallback> var1);

    public Set<String> getToolNames();

    public void setToolNames(Set<String> var1);

    @Nullable
    public Boolean isInternalToolExecutionEnabled();

    public void setInternalToolExecutionEnabled(@Nullable Boolean var1);

    public static Builder builder() {
        return new DefaultToolCallingChatOptions.Builder();
    }

    public static boolean isInternalToolExecutionEnabled(ChatOptions chatOptions) {
        FunctionCallingOptions functionCallingOptions;
        ToolCallingChatOptions toolCallingChatOptions;
        Assert.notNull((Object)chatOptions, (String)"chatOptions cannot be null");
        boolean internalToolExecutionEnabled = chatOptions instanceof ToolCallingChatOptions && (toolCallingChatOptions = (ToolCallingChatOptions)chatOptions).isInternalToolExecutionEnabled() != null ? Boolean.TRUE.equals(toolCallingChatOptions.isInternalToolExecutionEnabled()) : (chatOptions instanceof FunctionCallingOptions && (functionCallingOptions = (FunctionCallingOptions)chatOptions).getProxyToolCalls() != null ? Boolean.TRUE.equals(functionCallingOptions.getProxyToolCalls() == false) : true);
        return internalToolExecutionEnabled;
    }

    public static Set<String> mergeToolNames(Set<String> runtimeToolNames, Set<String> defaultToolNames) {
        Assert.notNull(runtimeToolNames, (String)"runtimeToolNames cannot be null");
        Assert.notNull(defaultToolNames, (String)"defaultToolNames cannot be null");
        if (CollectionUtils.isEmpty(runtimeToolNames)) {
            return new HashSet<String>(defaultToolNames);
        }
        return new HashSet<String>(runtimeToolNames);
    }

    public static List<FunctionCallback> mergeToolCallbacks(List<FunctionCallback> runtimeToolCallbacks, List<FunctionCallback> defaultToolCallbacks) {
        Assert.notNull(runtimeToolCallbacks, (String)"runtimeToolCallbacks cannot be null");
        Assert.notNull(defaultToolCallbacks, (String)"defaultToolCallbacks cannot be null");
        if (CollectionUtils.isEmpty(runtimeToolCallbacks)) {
            return new ArrayList<FunctionCallback>(defaultToolCallbacks);
        }
        return new ArrayList<FunctionCallback>(runtimeToolCallbacks);
    }

    public static Map<String, Object> mergeToolContext(Map<String, Object> runtimeToolContext, Map<String, Object> defaultToolContext) {
        Assert.notNull(runtimeToolContext, (String)"runtimeToolContext cannot be null");
        Assert.noNullElements(runtimeToolContext.keySet(), (String)"runtimeToolContext keys cannot be null");
        Assert.notNull(defaultToolContext, (String)"defaultToolContext cannot be null");
        Assert.noNullElements(defaultToolContext.keySet(), (String)"defaultToolContext keys cannot be null");
        HashMap<String, Object> mergedToolContext = new HashMap<String, Object>(defaultToolContext);
        mergedToolContext.putAll(runtimeToolContext);
        return mergedToolContext;
    }

    public static void validateToolCallbacks(List<FunctionCallback> toolCallbacks) {
        List<String> duplicateToolNames = ToolUtils.getDuplicateToolNames(toolCallbacks);
        if (!duplicateToolNames.isEmpty()) {
            throw new IllegalStateException("Multiple tools with the same name (%s) found in ToolCallingChatOptions".formatted(String.join((CharSequence)", ", duplicateToolNames)));
        }
    }

    public static interface Builder
    extends FunctionCallingOptions.Builder {
        public Builder toolCallbacks(List<FunctionCallback> var1);

        public Builder toolCallbacks(FunctionCallback ... var1);

        public Builder toolNames(Set<String> var1);

        public Builder toolNames(String ... var1);

        public Builder internalToolExecutionEnabled(@Nullable Boolean var1);

        @Override
        public Builder toolContext(Map<String, Object> var1);

        @Override
        public Builder toolContext(String var1, Object var2);

        @Override
        @Deprecated
        public Builder functionCallbacks(List<FunctionCallback> var1);

        @Override
        @Deprecated
        public Builder functionCallbacks(FunctionCallback ... var1);

        @Override
        @Deprecated
        public Builder functions(Set<String> var1);

        @Override
        @Deprecated
        public Builder function(String var1);

        @Override
        @Deprecated
        public Builder proxyToolCalls(@Nullable Boolean var1);

        @Override
        public Builder model(@Nullable String var1);

        @Override
        public Builder frequencyPenalty(@Nullable Double var1);

        @Override
        public Builder maxTokens(@Nullable Integer var1);

        @Override
        public Builder presencePenalty(@Nullable Double var1);

        @Override
        public Builder stopSequences(@Nullable List<String> var1);

        @Override
        public Builder temperature(@Nullable Double var1);

        @Override
        public Builder topK(@Nullable Integer var1);

        @Override
        public Builder topP(@Nullable Double var1);

        @Override
        public ToolCallingChatOptions build();
    }
}

