/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.openai;

import io.micrometer.observation.ObservationConvention;
import io.micrometer.observation.ObservationRegistry;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.metadata.DefaultUsage;
import org.springframework.ai.chat.metadata.EmptyUsage;
import org.springframework.ai.chat.metadata.Usage;
import org.springframework.ai.document.Document;
import org.springframework.ai.document.MetadataMode;
import org.springframework.ai.embedding.AbstractEmbeddingModel;
import org.springframework.ai.embedding.Embedding;
import org.springframework.ai.embedding.EmbeddingOptions;
import org.springframework.ai.embedding.EmbeddingRequest;
import org.springframework.ai.embedding.EmbeddingResponse;
import org.springframework.ai.embedding.EmbeddingResponseMetadata;
import org.springframework.ai.embedding.observation.DefaultEmbeddingModelObservationConvention;
import org.springframework.ai.embedding.observation.EmbeddingModelObservationContext;
import org.springframework.ai.embedding.observation.EmbeddingModelObservationConvention;
import org.springframework.ai.embedding.observation.EmbeddingModelObservationDocumentation;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.ai.openai.OpenAiEmbeddingOptions;
import org.springframework.ai.openai.api.OpenAiApi;
import org.springframework.ai.openai.api.common.OpenAiApiConstants;
import org.springframework.ai.retry.RetryUtils;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.util.Assert;

public class OpenAiEmbeddingModel
extends AbstractEmbeddingModel {
    private static final Logger logger = LoggerFactory.getLogger(OpenAiEmbeddingModel.class);
    private static final EmbeddingModelObservationConvention DEFAULT_OBSERVATION_CONVENTION = new DefaultEmbeddingModelObservationConvention();
    private final OpenAiEmbeddingOptions defaultOptions;
    private final RetryTemplate retryTemplate;
    private final OpenAiApi openAiApi;
    private final MetadataMode metadataMode;
    private final ObservationRegistry observationRegistry;
    private EmbeddingModelObservationConvention observationConvention = DEFAULT_OBSERVATION_CONVENTION;

    public OpenAiEmbeddingModel(OpenAiApi openAiApi) {
        this(openAiApi, MetadataMode.EMBED);
    }

    public OpenAiEmbeddingModel(OpenAiApi openAiApi, MetadataMode metadataMode) {
        this(openAiApi, metadataMode, OpenAiEmbeddingOptions.builder().model(OpenAiApi.DEFAULT_EMBEDDING_MODEL).build());
    }

    public OpenAiEmbeddingModel(OpenAiApi openAiApi, MetadataMode metadataMode, OpenAiEmbeddingOptions openAiEmbeddingOptions) {
        this(openAiApi, metadataMode, openAiEmbeddingOptions, RetryUtils.DEFAULT_RETRY_TEMPLATE);
    }

    public OpenAiEmbeddingModel(OpenAiApi openAiApi, MetadataMode metadataMode, OpenAiEmbeddingOptions options, RetryTemplate retryTemplate) {
        this(openAiApi, metadataMode, options, retryTemplate, ObservationRegistry.NOOP);
    }

    public OpenAiEmbeddingModel(OpenAiApi openAiApi, MetadataMode metadataMode, OpenAiEmbeddingOptions options, RetryTemplate retryTemplate, ObservationRegistry observationRegistry) {
        Assert.notNull((Object)openAiApi, (String)"openAiApi must not be null");
        Assert.notNull((Object)metadataMode, (String)"metadataMode must not be null");
        Assert.notNull((Object)options, (String)"options must not be null");
        Assert.notNull((Object)retryTemplate, (String)"retryTemplate must not be null");
        Assert.notNull((Object)observationRegistry, (String)"observationRegistry must not be null");
        this.openAiApi = openAiApi;
        this.metadataMode = metadataMode;
        this.defaultOptions = options;
        this.retryTemplate = retryTemplate;
        this.observationRegistry = observationRegistry;
    }

    public float[] embed(Document document) {
        Assert.notNull((Object)document, (String)"Document must not be null");
        return this.embed(document.getFormattedContent(this.metadataMode));
    }

    public EmbeddingResponse call(EmbeddingRequest request) {
        EmbeddingRequest embeddingRequest = this.buildEmbeddingRequest(request);
        OpenAiApi.EmbeddingRequest<List<String>> apiRequest = this.createRequest(embeddingRequest);
        EmbeddingModelObservationContext observationContext = EmbeddingModelObservationContext.builder().embeddingRequest(request).provider(OpenAiApiConstants.PROVIDER_NAME).requestOptions(embeddingRequest.getOptions()).build();
        return (EmbeddingResponse)EmbeddingModelObservationDocumentation.EMBEDDING_MODEL_OPERATION.observation((ObservationConvention)this.observationConvention, (ObservationConvention)DEFAULT_OBSERVATION_CONVENTION, () -> observationContext, this.observationRegistry).observe(() -> {
            OpenAiApi.EmbeddingList apiEmbeddingResponse = (OpenAiApi.EmbeddingList)this.retryTemplate.execute(ctx -> (OpenAiApi.EmbeddingList)this.openAiApi.embeddings(apiRequest).getBody());
            if (apiEmbeddingResponse == null) {
                logger.warn("No embeddings returned for request: {}", (Object)request);
                return new EmbeddingResponse(List.of());
            }
            OpenAiApi.Usage usage = apiEmbeddingResponse.usage();
            EmptyUsage embeddingResponseUsage = usage != null ? this.getDefaultUsage(usage) : new EmptyUsage();
            EmbeddingResponseMetadata metadata = new EmbeddingResponseMetadata(apiEmbeddingResponse.model(), (Usage)embeddingResponseUsage);
            List<Embedding> embeddings = apiEmbeddingResponse.data().stream().map(e -> new Embedding(e.embedding(), e.index())).toList();
            EmbeddingResponse embeddingResponse = new EmbeddingResponse(embeddings, metadata);
            observationContext.setResponse((Object)embeddingResponse);
            return embeddingResponse;
        });
    }

    private DefaultUsage getDefaultUsage(OpenAiApi.Usage usage) {
        return new DefaultUsage(usage.promptTokens(), usage.completionTokens(), usage.totalTokens(), (Object)usage);
    }

    private OpenAiApi.EmbeddingRequest<List<String>> createRequest(EmbeddingRequest request) {
        OpenAiEmbeddingOptions requestOptions = (OpenAiEmbeddingOptions)request.getOptions();
        return new OpenAiApi.EmbeddingRequest<List<String>>(request.getInstructions(), requestOptions.getModel(), requestOptions.getEncodingFormat(), requestOptions.getDimensions(), requestOptions.getUser());
    }

    private EmbeddingRequest buildEmbeddingRequest(EmbeddingRequest embeddingRequest) {
        OpenAiEmbeddingOptions runtimeOptions = null;
        if (embeddingRequest.getOptions() != null) {
            runtimeOptions = (OpenAiEmbeddingOptions)ModelOptionsUtils.copyToTarget((Object)embeddingRequest.getOptions(), EmbeddingOptions.class, OpenAiEmbeddingOptions.class);
        }
        OpenAiEmbeddingOptions requestOptions = runtimeOptions == null ? this.defaultOptions : OpenAiEmbeddingOptions.builder().model((String)ModelOptionsUtils.mergeOption((Object)runtimeOptions.getModel(), (Object)this.defaultOptions.getModel())).dimensions((Integer)ModelOptionsUtils.mergeOption((Object)runtimeOptions.getDimensions(), (Object)this.defaultOptions.getDimensions())).encodingFormat((String)ModelOptionsUtils.mergeOption((Object)runtimeOptions.getEncodingFormat(), (Object)this.defaultOptions.getEncodingFormat())).user((String)ModelOptionsUtils.mergeOption((Object)runtimeOptions.getUser(), (Object)this.defaultOptions.getUser())).build();
        return new EmbeddingRequest(embeddingRequest.getInstructions(), (EmbeddingOptions)requestOptions);
    }

    public void setObservationConvention(EmbeddingModelObservationConvention observationConvention) {
        Assert.notNull((Object)observationConvention, (String)"observationConvention cannot be null");
        this.observationConvention = observationConvention;
    }
}

