/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.core;

import java.util.Date;
import java.util.concurrent.ScheduledFuture;
import org.springframework.amqp.AmqpException;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.batch.BatchingStrategy;
import org.springframework.amqp.rabbit.batch.MessageBatch;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.connection.CorrelationData;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.scheduling.TaskScheduler;

public class BatchingRabbitTemplate
extends RabbitTemplate {
    private final BatchingStrategy batchingStrategy;
    private final TaskScheduler scheduler;
    private volatile ScheduledFuture<?> scheduledTask;

    public BatchingRabbitTemplate(BatchingStrategy batchingStrategy, TaskScheduler scheduler) {
        this.batchingStrategy = batchingStrategy;
        this.scheduler = scheduler;
    }

    public BatchingRabbitTemplate(ConnectionFactory connectionFactory, BatchingStrategy batchingStrategy, TaskScheduler scheduler) {
        super(connectionFactory);
        this.batchingStrategy = batchingStrategy;
        this.scheduler = scheduler;
    }

    @Override
    public synchronized void send(String exchange, String routingKey, Message message, CorrelationData correlationData) throws AmqpException {
        if (correlationData != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Cannot use batching with correlation data");
            }
            super.send(exchange, routingKey, message, correlationData);
        } else {
            Date next;
            MessageBatch batch;
            if (this.scheduledTask != null) {
                this.scheduledTask.cancel(false);
            }
            if ((batch = this.batchingStrategy.addToBatch(exchange, routingKey, message)) != null) {
                super.send(batch.getExchange(), batch.getRoutingKey(), batch.getMessage(), null);
            }
            if ((next = this.batchingStrategy.nextRelease()) != null) {
                this.scheduledTask = this.scheduler.schedule(() -> this.releaseBatches(), next);
            }
        }
    }

    public void flush() {
        this.releaseBatches();
    }

    private synchronized void releaseBatches() {
        for (MessageBatch batch : this.batchingStrategy.releaseBatches()) {
            super.send(batch.getExchange(), batch.getRoutingKey(), batch.getMessage(), null);
        }
    }

    @Override
    public void doStart() {
    }

    @Override
    public void doStop() {
        this.flush();
    }

    @Override
    public boolean isRunning() {
        return true;
    }
}

