/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.condition;

import java.util.ArrayList;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnResource;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.annotation.Order;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;

@Order(value=-2147483628)
class OnResourceCondition
extends SpringBootCondition {
    OnResourceCondition() {
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        @Nullable MultiValueMap attributes = metadata.getAllAnnotationAttributes(ConditionalOnResource.class.getName(), true);
        Assert.state((attributes != null ? 1 : 0) != 0, (String)"'attributes' must not be null");
        ResourceLoader loader = context.getResourceLoader();
        ArrayList<String> locations = new ArrayList<String>();
        @Nullable List resources = (List)attributes.get((Object)"resources");
        Assert.state((resources != null ? 1 : 0) != 0, (String)"'resources' must not be null");
        this.collectValues(locations, resources);
        Assert.state((!locations.isEmpty() ? 1 : 0) != 0, (String)"@ConditionalOnResource annotations must specify at least one resource location");
        ArrayList<String> missing = new ArrayList<String>();
        for (String location : locations) {
            String resource = context.getEnvironment().resolvePlaceholders(location);
            if (loader.getResource(resource).exists()) continue;
            missing.add(location);
        }
        if (!missing.isEmpty()) {
            return ConditionOutcome.noMatch(ConditionMessage.forCondition(ConditionalOnResource.class, new Object[0]).didNotFind("resource", "resources").items(ConditionMessage.Style.QUOTE, missing));
        }
        return ConditionOutcome.match(ConditionMessage.forCondition(ConditionalOnResource.class, new Object[0]).found("location", "locations").items(locations));
    }

    private void collectValues(List<String> names, List<@Nullable Object> resources) {
        for (Object resource : resources) {
            Object[] items = (Object[])resource;
            if (items == null) continue;
            for (Object item : items) {
                names.add((String)item);
            }
        }
    }
}

