/*
 * Copyright 2012-present the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.springframework.boot.cache.metrics;

import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.MeterBinder;

import org.springframework.data.redis.cache.RedisCache;

/**
 * {@link CacheMeterBinderProvider} implementation for Redis.
 *
 * @author Stephane Nicoll
 * @since 4.0.0
 */
public class RedisCacheMeterBinderProvider implements CacheMeterBinderProvider<RedisCache> {

	@Override
	public MeterBinder getMeterBinder(RedisCache cache, Iterable<Tag> tags) {
		return new RedisCacheMetrics(cache, tags);
	}

}
