/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cache.autoconfigure.metrics;

import com.github.benmanes.caffeine.cache.Cache;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.spring.cache.HazelcastCache;
import io.micrometer.core.instrument.binder.MeterBinder;
import javax.cache.CacheManager;
import org.cache2k.Cache2kBuilder;
import org.cache2k.extra.micrometer.Cache2kCacheMetrics;
import org.cache2k.extra.spring.SpringCache2kCache;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.cache.metrics.Cache2kCacheMeterBinderProvider;
import org.springframework.boot.cache.metrics.CacheMeterBinderProvider;
import org.springframework.boot.cache.metrics.CaffeineCacheMeterBinderProvider;
import org.springframework.boot.cache.metrics.HazelcastCacheMeterBinderProvider;
import org.springframework.boot.cache.metrics.JCacheCacheMeterBinderProvider;
import org.springframework.boot.cache.metrics.RedisCacheMeterBinderProvider;
import org.springframework.cache.caffeine.CaffeineCache;
import org.springframework.cache.jcache.JCacheCache;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.cache.RedisCache;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={MeterBinder.class, CacheMeterBinderProvider.class})
class CacheMeterBinderProvidersConfiguration {
    CacheMeterBinderProvidersConfiguration() {
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={RedisCache.class})
    static class RedisCacheMeterBinderProviderConfiguration {
        RedisCacheMeterBinderProviderConfiguration() {
        }

        @Bean
        RedisCacheMeterBinderProvider redisCacheMeterBinderProvider() {
            return new RedisCacheMeterBinderProvider();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={JCacheCache.class, CacheManager.class})
    @ConditionalOnMissingBean(value={JCacheCacheMeterBinderProvider.class})
    static class JCacheCacheMeterBinderProviderConfiguration {
        JCacheCacheMeterBinderProviderConfiguration() {
        }

        @Bean
        JCacheCacheMeterBinderProvider jCacheCacheMeterBinderProvider() {
            return new JCacheCacheMeterBinderProvider();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={HazelcastCache.class, Hazelcast.class})
    static class HazelcastCacheMeterBinderProviderConfiguration {
        HazelcastCacheMeterBinderProviderConfiguration() {
        }

        @Bean
        HazelcastCacheMeterBinderProvider hazelcastCacheMeterBinderProvider() {
            return new HazelcastCacheMeterBinderProvider();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={CaffeineCache.class, Cache.class})
    static class CaffeineCacheMeterBinderProviderConfiguration {
        CaffeineCacheMeterBinderProviderConfiguration() {
        }

        @Bean
        CaffeineCacheMeterBinderProvider caffeineCacheMeterBinderProvider() {
            return new CaffeineCacheMeterBinderProvider();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={Cache2kBuilder.class, SpringCache2kCache.class, Cache2kCacheMetrics.class})
    static class Cache2kCacheMeterBinderProviderConfiguration {
        Cache2kCacheMeterBinderProviderConfiguration() {
        }

        @Bean
        Cache2kCacheMeterBinderProvider cache2kCacheMeterBinderProvider() {
            return new Cache2kCacheMeterBinderProvider();
        }
    }
}

