/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.integration.autoconfigure;

import java.net.URI;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="spring.integration")
public class IntegrationProperties {
    private final Channel channel = new Channel();
    private final Endpoint endpoint = new Endpoint();
    private final Error error = new Error();
    private final RSocket rsocket = new RSocket();
    private final Poller poller = new Poller();
    private final Management management = new Management();

    public Channel getChannel() {
        return this.channel;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public Error getError() {
        return this.error;
    }

    public RSocket getRsocket() {
        return this.rsocket;
    }

    public Poller getPoller() {
        return this.poller;
    }

    public Management getManagement() {
        return this.management;
    }

    public static class Channel {
        private boolean autoCreate = true;
        private int maxUnicastSubscribers = Integer.MAX_VALUE;
        private int maxBroadcastSubscribers = Integer.MAX_VALUE;

        public void setAutoCreate(boolean autoCreate) {
            this.autoCreate = autoCreate;
        }

        public boolean isAutoCreate() {
            return this.autoCreate;
        }

        public void setMaxUnicastSubscribers(int maxUnicastSubscribers) {
            this.maxUnicastSubscribers = maxUnicastSubscribers;
        }

        public int getMaxUnicastSubscribers() {
            return this.maxUnicastSubscribers;
        }

        public void setMaxBroadcastSubscribers(int maxBroadcastSubscribers) {
            this.maxBroadcastSubscribers = maxBroadcastSubscribers;
        }

        public int getMaxBroadcastSubscribers() {
            return this.maxBroadcastSubscribers;
        }
    }

    public static class Endpoint {
        private boolean throwExceptionOnLateReply;
        private List<String> readOnlyHeaders = new ArrayList<String>();
        private List<String> noAutoStartup = new ArrayList<String>();
        private Duration defaultTimeout = Duration.ofSeconds(30L);

        public void setThrowExceptionOnLateReply(boolean throwExceptionOnLateReply) {
            this.throwExceptionOnLateReply = throwExceptionOnLateReply;
        }

        public boolean isThrowExceptionOnLateReply() {
            return this.throwExceptionOnLateReply;
        }

        public List<String> getReadOnlyHeaders() {
            return this.readOnlyHeaders;
        }

        public void setReadOnlyHeaders(List<String> readOnlyHeaders) {
            this.readOnlyHeaders = readOnlyHeaders;
        }

        public List<String> getNoAutoStartup() {
            return this.noAutoStartup;
        }

        public void setNoAutoStartup(List<String> noAutoStartup) {
            this.noAutoStartup = noAutoStartup;
        }

        public Duration getDefaultTimeout() {
            return this.defaultTimeout;
        }

        public void setDefaultTimeout(Duration defaultTimeout) {
            this.defaultTimeout = defaultTimeout;
        }
    }

    public static class Error {
        private boolean requireSubscribers = true;
        private boolean ignoreFailures = true;

        public boolean isRequireSubscribers() {
            return this.requireSubscribers;
        }

        public void setRequireSubscribers(boolean requireSubscribers) {
            this.requireSubscribers = requireSubscribers;
        }

        public boolean isIgnoreFailures() {
            return this.ignoreFailures;
        }

        public void setIgnoreFailures(boolean ignoreFailures) {
            this.ignoreFailures = ignoreFailures;
        }
    }

    public static class RSocket {
        private final Client client = new Client();
        private final Server server = new Server();

        public Client getClient() {
            return this.client;
        }

        public Server getServer() {
            return this.server;
        }

        public static class Client {
            private @Nullable String host;
            private @Nullable Integer port;
            private @Nullable URI uri;

            public void setHost(@Nullable String host) {
                this.host = host;
            }

            public @Nullable String getHost() {
                return this.host;
            }

            public void setPort(@Nullable Integer port) {
                this.port = port;
            }

            public @Nullable Integer getPort() {
                return this.port;
            }

            public void setUri(@Nullable URI uri) {
                this.uri = uri;
            }

            public @Nullable URI getUri() {
                return this.uri;
            }
        }

        public static class Server {
            private boolean messageMappingEnabled;

            public boolean isMessageMappingEnabled() {
                return this.messageMappingEnabled;
            }

            public void setMessageMappingEnabled(boolean messageMappingEnabled) {
                this.messageMappingEnabled = messageMappingEnabled;
            }
        }
    }

    public static class Poller {
        private int maxMessagesPerPoll = Integer.MIN_VALUE;
        private Duration receiveTimeout = Duration.ofSeconds(1L);
        private @Nullable Duration fixedDelay;
        private @Nullable Duration fixedRate;
        private @Nullable Duration initialDelay;
        private @Nullable String cron;

        public int getMaxMessagesPerPoll() {
            return this.maxMessagesPerPoll;
        }

        public void setMaxMessagesPerPoll(int maxMessagesPerPoll) {
            this.maxMessagesPerPoll = maxMessagesPerPoll;
        }

        public Duration getReceiveTimeout() {
            return this.receiveTimeout;
        }

        public void setReceiveTimeout(Duration receiveTimeout) {
            this.receiveTimeout = receiveTimeout;
        }

        public @Nullable Duration getFixedDelay() {
            return this.fixedDelay;
        }

        public void setFixedDelay(@Nullable Duration fixedDelay) {
            this.fixedDelay = fixedDelay;
        }

        public @Nullable Duration getFixedRate() {
            return this.fixedRate;
        }

        public void setFixedRate(@Nullable Duration fixedRate) {
            this.fixedRate = fixedRate;
        }

        public @Nullable Duration getInitialDelay() {
            return this.initialDelay;
        }

        public void setInitialDelay(@Nullable Duration initialDelay) {
            this.initialDelay = initialDelay;
        }

        public @Nullable String getCron() {
            return this.cron;
        }

        public void setCron(@Nullable String cron) {
            this.cron = cron;
        }
    }

    public static class Management {
        private boolean defaultLoggingEnabled = true;
        private List<String> observationPatterns = new ArrayList<String>();

        public boolean isDefaultLoggingEnabled() {
            return this.defaultLoggingEnabled;
        }

        public void setDefaultLoggingEnabled(boolean defaultLoggingEnabled) {
            this.defaultLoggingEnabled = defaultLoggingEnabled;
        }

        public List<String> getObservationPatterns() {
            return this.observationPatterns;
        }

        public void setObservationPatterns(List<String> observationPatterns) {
            this.observationPatterns = observationPatterns;
        }
    }
}

