/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.r2dbc.docker.compose;

import io.r2dbc.spi.ConnectionFactoryOptions;
import io.r2dbc.spi.Option;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.docker.compose.core.RunningService;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class ConnectionFactoryOptionsBuilder {
    private static final String PARAMETERS_LABEL = "org.springframework.boot.r2dbc.parameters";
    private final String driver;
    private final int sourcePort;

    ConnectionFactoryOptionsBuilder(String driver, int containerPort) {
        Assert.notNull((Object)driver, (String)"'driver' must not be null");
        this.driver = driver;
        this.sourcePort = containerPort;
    }

    ConnectionFactoryOptions build(RunningService service, String database, @Nullable String user, @Nullable String password) {
        Assert.notNull((Object)service, (String)"'service' must not be null");
        Assert.notNull((Object)database, (String)"'database' must not be null");
        ConnectionFactoryOptions.Builder builder = ConnectionFactoryOptions.builder().option(ConnectionFactoryOptions.DRIVER, (Object)this.driver).option(ConnectionFactoryOptions.HOST, (Object)service.host()).option(ConnectionFactoryOptions.PORT, (Object)service.ports().get(this.sourcePort)).option(ConnectionFactoryOptions.DATABASE, (Object)database);
        if (StringUtils.hasLength((String)user)) {
            builder.option(ConnectionFactoryOptions.USER, (Object)user);
        }
        if (StringUtils.hasLength((String)password)) {
            builder.option(ConnectionFactoryOptions.PASSWORD, (Object)password);
        }
        this.applyParameters(service, builder);
        return builder.build();
    }

    private void applyParameters(RunningService service, ConnectionFactoryOptions.Builder builder) {
        String parameters = (String)service.labels().get(PARAMETERS_LABEL);
        try {
            if (StringUtils.hasText((String)parameters)) {
                this.parseParameters(parameters).forEach((name, value) -> builder.option(Option.valueOf((String)name), value));
            }
        }
        catch (RuntimeException ex) {
            throw new IllegalStateException("Unable to apply R2DBC label parameters '%s' defined on service %s".formatted(parameters, service));
        }
    }

    private Map<String, String> parseParameters(String parameters) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (String parameter : StringUtils.commaDelimitedListToStringArray((String)parameters)) {
            String[] parts = parameter.split("=");
            Assert.state((parts.length == 2 ? 1 : 0) != 0, () -> "'parameters' [%s] must contain parsable value".formatted(parameter));
            result.put(parts[0], parts[1]);
        }
        return Collections.unmodifiableMap(result);
    }
}

