/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.json;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.cloud.function.context.catalog.FunctionTypeUtils;

public abstract class JsonMapper {
    private static Log logger = LogFactory.getLog(JsonMapper.class);
    private static final ObjectMapper mapper = new ObjectMapper().enable(DeserializationFeature.FAIL_ON_TRAILING_TOKENS);

    public <T> T fromJson(Object json, Type type) {
        if (json instanceof Collection) {
            if (FunctionTypeUtils.isTypeCollection(type)) {
                return (T)json;
            }
            Collection inputs = (Collection)json;
            Type itemType = FunctionTypeUtils.getImmediateGenericType(type, 0);
            AbstractCollection results = FunctionTypeUtils.getRawType(type).isAssignableFrom(List.class) ? new ArrayList() : new HashSet();
            for (Object input : inputs) {
                results.add(this.doFromJson(input, itemType));
            }
            return (T)results;
        }
        if (!(json instanceof String || json instanceof byte[] || json instanceof Reader)) {
            json = this.toJson(json);
            if (FunctionTypeUtils.getRawType(type) == String.class) {
                return (T)new String((byte[])json, StandardCharsets.UTF_8);
            }
            if (FunctionTypeUtils.getRawType(type) == byte[].class) {
                return (T)json;
            }
        }
        if (json instanceof String && (String.class == type || byte[].class == type)) {
            return (T)(String.class == type ? json : (Object)((String)json).getBytes(StandardCharsets.UTF_8));
        }
        return this.doFromJson(json, type);
    }

    protected abstract <T> T doFromJson(Object var1, Type var2);

    public byte[] toJson(Object value) {
        byte[] result = null;
        if (JsonMapper.isJsonString(value)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"String already represents JSON. Skipping conversion in favor of 'getBytes(StandardCharsets.UTF_8'.");
            }
            result = value instanceof byte[] ? (byte[])value : ((String)value).getBytes(StandardCharsets.UTF_8);
        } else if (value instanceof byte[]) {
            result = (byte[])value;
        }
        return result;
    }

    public abstract String toString(Object var1);

    public static boolean isJsonString(Object value) {
        if (value instanceof byte[]) {
            value = new String((byte[])value, StandardCharsets.UTF_8);
        }
        if (value instanceof String) {
            try {
                mapper.readTree((String)value);
                try {
                    Integer.parseInt((String)value);
                    return false;
                }
                catch (Exception e) {
                    return true;
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public static boolean isJsonStringRepresentsCollection(Object value) {
        if (value instanceof Collection && !value.getClass().getPackage().getName().startsWith("reactor.util.function")) {
            return true;
        }
        if (value instanceof byte[]) {
            value = new String((byte[])value, StandardCharsets.UTF_8);
        }
        if (value instanceof String) {
            try {
                new JSONArray((String)value);
            }
            catch (JSONException e) {
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isJsonStringRepresentsMap(Object value) {
        if (value instanceof byte[]) {
            value = new String((byte[])value, StandardCharsets.UTF_8);
        }
        if (value instanceof String) {
            try {
                new JSONObject(value);
            }
            catch (JSONException e) {
                return false;
            }
            return true;
        }
        return false;
    }
}

