/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.function.cloudevent;

import java.net.URI;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.cloud.function.cloudevent.CloudEventHeaderEnricher;
import org.springframework.cloud.function.cloudevent.CloudEventMessageBuilder;
import org.springframework.cloud.function.cloudevent.CloudEventMessageUtils;
import org.springframework.cloud.function.context.message.MessageUtils;
import org.springframework.cloud.function.core.FunctionInvocationHelper;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.converter.CompositeMessageConverter;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class CloudEventsFunctionInvocationHelper
implements FunctionInvocationHelper<Message<?>>,
ApplicationContextAware {
    private Log logger = LogFactory.getLog(this.getClass());
    private ConfigurableApplicationContext applicationContext;
    private final CloudEventHeaderEnricher cloudEventAttributesProvider;
    private CompositeMessageConverter messageConverter;
    private final Class<?> CLOUD_EVENT_CLASS;

    CloudEventsFunctionInvocationHelper(@Nullable CloudEventHeaderEnricher cloudEventHeadersProvider) {
        this.cloudEventAttributesProvider = cloudEventHeadersProvider;
        Class<?> clazz = null;
        try {
            clazz = Thread.currentThread().getContextClassLoader().loadClass("io.cloudevents.CloudEvent");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.CLOUD_EVENT_CLASS = clazz;
    }

    public boolean isRetainOutputAsMessage(Message<?> message) {
        return message.getHeaders().containsKey((Object)"partitionKey") || message.getHeaders().containsKey((Object)MessageUtils.MESSAGE_TYPE) && message.getHeaders().get((Object)MessageUtils.MESSAGE_TYPE).equals(CloudEventMessageUtils.CLOUDEVENT_VALUE);
    }

    public Message<?> preProcessInput(Message<?> input, Object inputConverter) {
        try {
            return CloudEventMessageUtils.toCanonical(input, (MessageConverter)inputConverter);
        }
        catch (Exception e) {
            return input;
        }
    }

    public void setMessageConverter(CompositeMessageConverter messageConverter) {
        this.messageConverter = messageConverter;
    }

    public Message<?> postProcessResult(Object result, Message<?> input) {
        Object convertedResult = result;
        if (this.messageConverter != null && this.CLOUD_EVENT_CLASS != null && this.CLOUD_EVENT_CLASS.isAssignableFrom(result.getClass())) {
            convertedResult = this.messageConverter.toMessage(result, input.getHeaders());
        }
        String targetPrefix = CloudEventMessageUtils.DEFAULT_ATTR_PREFIX;
        if (input != null) {
            targetPrefix = CloudEventMessageUtils.determinePrefixToUse((Map<String, Object>)input.getHeaders(), true);
        } else if (result instanceof Message) {
            Message resultMessage = (Message)result;
            targetPrefix = CloudEventMessageUtils.determinePrefixToUse((Map<String, Object>)resultMessage.getHeaders(), true);
        }
        Assert.hasText((String)targetPrefix, (String)"Unable to determine prefix for Cloud Event atttributes, which they must have according to protocol specification. Consider adding 'target-protocol' header with values of one of the supported protocols - [kafka, amqp, http]");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Cloud event attributes will be prefixed with '" + targetPrefix + "'"));
        }
        return this.doPostProcessResult(convertedResult, targetPrefix);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = (ConfigurableApplicationContext)applicationContext;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Message<?> doPostProcessResult(Object result, String targetPrefix) {
        void var4_8;
        Message resultMessage = null;
        if (result instanceof Message) {
            if (!CloudEventMessageUtils.isCloudEvent((Message)result)) return (Message)result;
            CloudEventMessageBuilder cloudEventMessageBuilder = CloudEventMessageBuilder.fromMessage((Message)result);
        } else {
            CloudEventMessageBuilder<Object> cloudEventMessageBuilder = CloudEventMessageBuilder.withData(result).setId(UUID.randomUUID().toString()).setSource(URI.create("http://spring.io/" + this.getApplicationName())).setType(result.getClass().getName());
        }
        if (this.cloudEventAttributesProvider != null) {
            void var4_6;
            CloudEventMessageBuilder<?> cloudEventMessageBuilder = this.cloudEventAttributesProvider.enrich((CloudEventMessageBuilder<?>)var4_6);
        }
        resultMessage = var4_8.build(targetPrefix);
        if (!this.logger.isDebugEnabled()) return resultMessage;
        this.logger.debug((Object)("Cloud Event result message: " + String.valueOf(resultMessage)));
        return resultMessage;
    }

    private String getApplicationName() {
        ConfigurableEnvironment environment = this.applicationContext.getEnvironment();
        String name = environment.getProperty("spring.application.name");
        return StringUtils.hasText((String)name) ? name : "";
    }
}

