/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig;

import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.sleuth.SpanNamer;
import org.springframework.cloud.sleuth.autoconfig.SleuthBaggageProperties;
import org.springframework.cloud.sleuth.autoconfig.SleuthSpanFilterProperties;
import org.springframework.cloud.sleuth.autoconfig.SleuthTracerProperties;
import org.springframework.cloud.sleuth.exporter.SpanFilter;
import org.springframework.cloud.sleuth.exporter.SpanIgnoringSpanFilter;
import org.springframework.cloud.sleuth.internal.DefaultSpanNamer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(value={"spring.sleuth.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={SleuthSpanFilterProperties.class, SleuthBaggageProperties.class, SleuthTracerProperties.class})
public class TraceConfiguration {
    @Bean
    @ConditionalOnMissingBean
    SpanNamer defaultSpanNamer() {
        return new DefaultSpanNamer();
    }

    @Bean
    @ConditionalOnProperty(value={"spring.sleuth.span-filter.enabled"}, matchIfMissing=true)
    SpanFilter spanIgnoringSpanExporter(SleuthSpanFilterProperties sleuthSpanFilterProperties) {
        return new SpanIgnoringSpanFilter(sleuthSpanFilterProperties.getSpanNamePatternsToSkip(), sleuthSpanFilterProperties.getAdditionalSpanNamePatternsToIgnore());
    }
}

