/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.brave.instrument.web;

import brave.Tracer;
import brave.propagation.CurrentTraceContext;
import brave.propagation.TraceContext;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.brave.bridge.BraveSpan;
import org.springframework.cloud.sleuth.instrument.web.SpanFromContextRetriever;
import reactor.util.context.Context;

public class BraveSpanFromContextRetriever
implements SpanFromContextRetriever {
    private final CurrentTraceContext currentTraceContext;
    private final Tracer tracer;

    public BraveSpanFromContextRetriever(CurrentTraceContext currentTraceContext, Tracer tracer) {
        this.currentTraceContext = currentTraceContext;
        this.tracer = tracer;
    }

    public Span findSpan(Context context) {
        Object braveSpan = context.getOrDefault(brave.Span.class, null);
        if (braveSpan != null) {
            return BraveSpan.fromBrave((brave.Span)braveSpan);
        }
        Object braveContext = context.getOrDefault(TraceContext.class, null);
        if (braveContext != null) {
            TraceContext traceContext = (TraceContext)braveContext;
            try (CurrentTraceContext.Scope scope = this.currentTraceContext.maybeScope(traceContext);){
                Span span = BraveSpan.fromBrave(this.tracer.currentSpan());
                return span;
            }
        }
        return null;
    }
}

