/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.kafka;

import java.util.function.Function;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.springframework.cloud.sleuth.instrument.kafka.ReactiveKafkaTracingPropagator;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.kafka.receiver.KafkaReceiver;
import reactor.kafka.receiver.ReceiverOptions;
import reactor.kafka.receiver.ReceiverRecord;
import reactor.kafka.receiver.internals.ConsumerFactory;
import reactor.kafka.sender.TransactionManager;

public class TracingKafkaReceiver<K, V>
implements KafkaReceiver<K, V> {
    private final ReactiveKafkaTracingPropagator reactiveKafkaTracingPropagator;
    private final KafkaReceiver<K, V> delegate;

    public TracingKafkaReceiver(ReactiveKafkaTracingPropagator reactiveKafkaTracingPropagator, KafkaReceiver<K, V> delegate) {
        this.reactiveKafkaTracingPropagator = reactiveKafkaTracingPropagator;
        this.delegate = delegate;
    }

    public static <K, V> KafkaReceiver<K, V> create(ReactiveKafkaTracingPropagator reactiveKafkaTracingPropagator, ReceiverOptions<K, V> options) {
        return new TracingKafkaReceiver<K, V>(reactiveKafkaTracingPropagator, KafkaReceiver.create(options));
    }

    public static <K, V> KafkaReceiver<K, V> create(ReactiveKafkaTracingPropagator reactiveKafkaTracingPropagator, ConsumerFactory factory, ReceiverOptions<K, V> options) {
        return new TracingKafkaReceiver<K, V>(reactiveKafkaTracingPropagator, KafkaReceiver.create((ConsumerFactory)factory, options));
    }

    public Flux<ReceiverRecord<K, V>> receive(Integer prefetch) {
        return this.delegate.receive(prefetch).transformDeferred(this.reactiveKafkaTracingPropagator::propagateSpanContextToReactiveContext);
    }

    public Flux<ReceiverRecord<K, V>> receive() {
        return this.delegate.receive().transformDeferred(this.reactiveKafkaTracingPropagator::propagateSpanContextToReactiveContext);
    }

    public Flux<Flux<ConsumerRecord<K, V>>> receiveAutoAck(Integer prefetch) {
        return this.delegate.receiveAutoAck(prefetch).map(this.reactiveKafkaTracingPropagator::propagateSpanContextToReactiveContext);
    }

    public Flux<Flux<ConsumerRecord<K, V>>> receiveAutoAck() {
        return this.delegate.receiveAutoAck().map(this.reactiveKafkaTracingPropagator::propagateSpanContextToReactiveContext);
    }

    public Flux<ConsumerRecord<K, V>> receiveAtmostOnce(Integer prefetch) {
        return this.delegate.receiveAtmostOnce(prefetch).transformDeferred(this.reactiveKafkaTracingPropagator::propagateSpanContextToReactiveContext);
    }

    public Flux<ConsumerRecord<K, V>> receiveAtmostOnce() {
        return this.delegate.receiveAtmostOnce().transformDeferred(this.reactiveKafkaTracingPropagator::propagateSpanContextToReactiveContext);
    }

    public Flux<Flux<ConsumerRecord<K, V>>> receiveExactlyOnce(TransactionManager transactionManager, Integer prefetch) {
        return this.delegate.receiveExactlyOnce(transactionManager, prefetch);
    }

    public <T> Mono<T> doOnConsumer(Function<Consumer<K, V>, ? extends T> function) {
        return this.delegate.doOnConsumer(function);
    }
}

