/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.task;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.SpanAndScope;
import org.springframework.cloud.sleuth.ThreadLocalSpan;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.docs.AssertingSpan;
import org.springframework.cloud.sleuth.instrument.task.SleuthTaskSpan;
import org.springframework.cloud.task.listener.TaskExecutionListener;
import org.springframework.cloud.task.repository.TaskExecution;
import org.springframework.core.Ordered;

public class TraceTaskExecutionListener
implements TaskExecutionListener,
Ordered {
    private static final Log log = LogFactory.getLog(TraceTaskExecutionListener.class);
    private final Tracer tracer;
    private final ThreadLocalSpan threadLocalSpan;
    private final String projectName;

    public TraceTaskExecutionListener(Tracer tracer, String projectName) {
        this.tracer = tracer;
        this.threadLocalSpan = new ThreadLocalSpan(tracer);
        this.projectName = projectName;
    }

    public void onTaskStartup(TaskExecution taskExecution) {
        AssertingSpan span = SleuthTaskSpan.TASK_EXECUTION_LISTENER_SPAN.wrap(this.tracer.nextSpan()).name(this.projectName).start();
        this.threadLocalSpan.set((Span)span);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Put the span [" + span + "] to thread local"));
        }
    }

    public void onTaskEnd(TaskExecution taskExecution) {
        SpanAndScope spanAndScope = this.threadLocalSpan.get();
        spanAndScope.close();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Removed the [" + spanAndScope.getSpan() + "] from thread local"));
        }
    }

    public void onTaskFailed(TaskExecution taskExecution, Throwable throwable) {
        SpanAndScope spanAndScope = this.threadLocalSpan.get();
        spanAndScope.getSpan().error(throwable);
        spanAndScope.close();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Removed the [" + spanAndScope.getSpan() + "] from thread local and added error"));
        }
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

