/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web;

import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Subscription;
import org.springframework.beans.BeansException;
import org.springframework.cloud.sleuth.CurrentTraceContext;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.TraceContext;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.docs.AssertingSpan;
import org.springframework.cloud.sleuth.docs.TagKey;
import org.springframework.cloud.sleuth.http.HttpServerHandler;
import org.springframework.cloud.sleuth.http.HttpServerRequest;
import org.springframework.cloud.sleuth.http.HttpServerResponse;
import org.springframework.cloud.sleuth.instrument.reactor.ReactorSleuth;
import org.springframework.cloud.sleuth.instrument.reactor.TraceContextPropagator;
import org.springframework.cloud.sleuth.instrument.web.SleuthWebSpan;
import org.springframework.cloud.sleuth.instrument.web.SpanFromContextRetriever;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.Ordered;
import org.springframework.http.HttpStatus;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.reactive.HandlerMapping;
import org.springframework.web.server.ResponseStatusException;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.CoreSubscriber;
import reactor.core.Scannable;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoOperator;
import reactor.util.annotation.Nullable;
import reactor.util.context.Context;

public class TraceWebFilter
implements WebFilter,
Ordered,
ApplicationContextAware {
    protected static final String TRACE_REQUEST_ATTR = Span.class.getName();
    private static final Log log = LogFactory.getLog(TraceWebFilter.class);
    private static final String TRACE_SPAN_WITHOUT_PARENT = TraceWebFilter.class.getName() + ".SPAN_WITH_NO_PARENT";
    private final Tracer tracer;
    private final HttpServerHandler handler;
    private CurrentTraceContext currentTraceContext;
    private ApplicationContext applicationContext;
    private int order;
    private SpanFromContextRetriever spanFromContextRetriever;

    @Deprecated
    public TraceWebFilter(Tracer tracer, HttpServerHandler handler) {
        this.tracer = tracer;
        this.handler = handler;
        this.currentTraceContext = null;
    }

    public TraceWebFilter(Tracer tracer, HttpServerHandler handler, CurrentTraceContext currentTraceContext) {
        this.tracer = tracer;
        this.handler = handler;
        this.currentTraceContext = currentTraceContext;
    }

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        String uri = exchange.getRequest().getPath().pathWithinApplication().value();
        Mono source = chain.filter(exchange);
        boolean tracePresent = this.isTracePresent();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Received a request to uri [" + uri + "]"));
        }
        return new MonoWebFilterTrace((Mono<? extends Void>)source, exchange, tracePresent, this, this.spanFromContextRetriever());
    }

    private boolean isTracePresent() {
        boolean tracePresent;
        boolean bl = tracePresent = this.tracer.currentSpan() != null;
        if (tracePresent) {
            this.tracer.withSpan(null);
        }
        return tracePresent;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    private CurrentTraceContext currentTraceContext() {
        if (this.currentTraceContext == null) {
            this.currentTraceContext = (CurrentTraceContext)this.applicationContext.getBean(CurrentTraceContext.class);
        }
        return this.currentTraceContext;
    }

    private SpanFromContextRetriever spanFromContextRetriever() {
        if (this.spanFromContextRetriever == null) {
            this.spanFromContextRetriever = (SpanFromContextRetriever)this.applicationContext.getBeanProvider(SpanFromContextRetriever.class).getIfAvailable(() -> new SpanFromContextRetriever(){});
        }
        return this.spanFromContextRetriever;
    }

    static final class WrappedResponse
    implements HttpServerResponse {
        final ServerHttpResponse delegate;
        final String method;
        final String httpRoute;
        final Throwable throwable;

        WrappedResponse(ServerHttpResponse resp, String method, String httpRoute, Throwable throwable) {
            this.delegate = resp;
            this.method = method;
            this.httpRoute = httpRoute;
            this.throwable = throwable;
        }

        public String method() {
            return this.method;
        }

        public String route() {
            return this.httpRoute;
        }

        public ServerHttpResponse unwrap() {
            return this.delegate;
        }

        public int statusCode() {
            if (!this.delegate.isCommitted() && this.throwable != null) {
                if (this.throwable instanceof ResponseStatusException) {
                    return ((ResponseStatusException)this.throwable).getRawStatusCode();
                }
                return HttpStatus.INTERNAL_SERVER_ERROR.value();
            }
            HttpStatus statusCode = this.delegate.getStatusCode();
            return statusCode != null ? statusCode.value() : 0;
        }

        public Collection<String> headerNames() {
            return this.delegate.getHeaders().keySet();
        }

        public Throwable error() {
            return this.throwable;
        }
    }

    static final class WrappedRequest
    implements HttpServerRequest {
        final ServerHttpRequest delegate;

        WrappedRequest(ServerHttpRequest delegate) {
            this.delegate = delegate;
        }

        public Collection<String> headerNames() {
            return this.delegate.getHeaders().keySet();
        }

        public ServerHttpRequest unwrap() {
            return this.delegate;
        }

        public String method() {
            return this.delegate.getMethodValue();
        }

        public String path() {
            return this.delegate.getPath().toString();
        }

        public String url() {
            return this.delegate.getURI().toString();
        }

        public String header(String name) {
            return this.delegate.getHeaders().getFirst(name);
        }
    }

    private static class MonoWebFilterTrace
    extends MonoOperator<Void, Void>
    implements TraceContextPropagator {
        final ServerWebExchange exchange;
        final Tracer tracer;
        final Span span;
        final HttpServerHandler handler;
        final AtomicBoolean initialSpanAlreadyRemoved = new AtomicBoolean();
        final boolean initialTracePresent;
        final CurrentTraceContext currentTraceContext;
        final SpanFromContextRetriever spanFromContextRetriever;

        MonoWebFilterTrace(Mono<? extends Void> source, ServerWebExchange exchange, boolean initialTracePresent, TraceWebFilter parent, SpanFromContextRetriever spanFromContextRetriever) {
            super(source);
            this.tracer = parent.tracer;
            this.handler = parent.handler;
            this.currentTraceContext = parent.currentTraceContext();
            this.exchange = exchange;
            this.span = (Span)exchange.getAttribute(TRACE_REQUEST_ATTR);
            this.initialTracePresent = initialTracePresent;
            this.spanFromContextRetriever = spanFromContextRetriever;
        }

        public void subscribe(CoreSubscriber<? super Void> subscriber) {
            Context context = this.contextWithoutInitialSpan(subscriber.currentContext());
            Span span = this.findOrCreateSpan(context);
            try (CurrentTraceContext.Scope scope = this.currentTraceContext.maybeScope(span.context());){
                this.source.subscribe((CoreSubscriber)new WebFilterTraceSubscriber(subscriber, context, span, this));
            }
        }

        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.RUN_STYLE) {
                return Scannable.Attr.RunStyle.SYNC;
            }
            return super.scanUnsafe(key);
        }

        private Context contextWithoutInitialSpan(Context context) {
            if (this.initialTracePresent && !this.initialSpanAlreadyRemoved.get()) {
                context = context.delete(Span.class);
                this.initialSpanAlreadyRemoved.set(true);
            }
            return context;
        }

        private Span findOrCreateSpan(Context c) {
            Span span;
            AssertingSpan assertingSpan = null;
            if (c.hasKey(Span.class)) {
                Span parent = (Span)c.get(Span.class);
                try (Tracer.SpanInScope spanInScope = this.tracer.withSpan(parent);){
                    span = this.tracer.nextSpan();
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Found span in reactor context" + span));
                }
            } else {
                if (this.span != null) {
                    try (Tracer.SpanInScope spanInScope = this.tracer.withSpan(this.span);){
                        span = this.tracer.nextSpan();
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Found span in attribute " + span));
                    }
                }
                span = this.spanFromContextRetriever.findSpan(c);
                if (this.span == null && span == null) {
                    span = this.handler.handleReceive((HttpServerRequest)new WrappedRequest(this.exchange.getRequest()));
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Handled receive of span " + span));
                    }
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)("Found tracer specific span in reactor context [" + span + "]"));
                }
                assertingSpan = SleuthWebSpan.WEB_FILTER_SPAN.wrap(span);
                this.exchange.getAttributes().put(TRACE_REQUEST_ATTR, assertingSpan);
            }
            if (assertingSpan == null) {
                assertingSpan = SleuthWebSpan.WEB_FILTER_SPAN.wrap(span);
            }
            return assertingSpan;
        }

        static final class WebFilterTraceSubscriber
        implements CoreSubscriber<Void> {
            final CoreSubscriber<? super Void> actual;
            final Context context;
            final Span span;
            final Tracer tracer;
            final ServerWebExchange exchange;
            final HttpServerHandler handler;

            WebFilterTraceSubscriber(CoreSubscriber<? super Void> actual, Context context, Span span, MonoWebFilterTrace parent) {
                this.actual = actual;
                this.span = span;
                this.tracer = parent.tracer;
                this.context = ReactorSleuth.wrapContext(context.put(TraceContext.class, (Object)span.context()));
                this.exchange = parent.exchange;
                this.handler = parent.handler;
            }

            public void onSubscribe(Subscription subscription) {
                this.actual.onSubscribe(subscription);
            }

            public void onNext(Void aVoid) {
            }

            public void onError(Throwable t) {
                try (Tracer.SpanInScope ignored = this.terminateSpan(t);){
                    this.actual.onError(t);
                }
            }

            public void onComplete() {
                try (Tracer.SpanInScope ignored = this.terminateSpan(null);){
                    this.actual.onComplete();
                }
            }

            public Context currentContext() {
                return this.context;
            }

            private Tracer.SpanInScope terminateSpan(@Nullable Throwable t) {
                Object attribute = this.exchange.getAttribute(HandlerMapping.BEST_MATCHING_HANDLER_ATTRIBUTE);
                this.addClassMethodTag(attribute, this.span);
                this.addClassNameTag(attribute, this.span);
                Object pattern = this.exchange.getAttribute(HandlerMapping.BEST_MATCHING_PATTERN_ATTRIBUTE);
                String httpRoute = pattern != null ? pattern.toString() : "";
                this.addResponseTagsForSpanWithoutParent(this.exchange, this.exchange.getResponse(), this.span);
                WrappedResponse response = new WrappedResponse(this.exchange.getResponse(), this.exchange.getRequest().getMethodValue(), httpRoute, t);
                this.handler.handleSend((HttpServerResponse)response, this.span);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Handled send of " + this.span));
                }
                return this.tracer.withSpan(null);
            }

            private void addClassMethodTag(Object handler, Span span) {
                if (handler instanceof HandlerMethod) {
                    String methodName = ((HandlerMethod)handler).getMethod().getName();
                    SleuthWebSpan.WEB_FILTER_SPAN.wrap(span).tag((TagKey)SleuthWebSpan.Tags.METHOD, methodName);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Adding a method tag with value [" + methodName + "] to a span " + span));
                    }
                }
            }

            private void addClassNameTag(Object handler, Span span) {
                if (handler == null) {
                    return;
                }
                String className = handler instanceof HandlerMethod ? ((HandlerMethod)handler).getBeanType().getSimpleName() : handler.getClass().getSimpleName();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Adding a class tag with value [" + className + "] to a span " + span));
                }
                SleuthWebSpan.WEB_FILTER_SPAN.wrap(span).tag((TagKey)SleuthWebSpan.Tags.CLASS, className);
            }

            private void addResponseTagsForSpanWithoutParent(ServerWebExchange exchange, ServerHttpResponse response, Span span) {
                if (this.spanWithoutParent(exchange) && response.getStatusCode() != null && span != null) {
                    SleuthWebSpan.WEB_FILTER_SPAN.wrap(span).tag((TagKey)SleuthWebSpan.Tags.CLASS, String.valueOf(response.getStatusCode().value()));
                }
            }

            private boolean spanWithoutParent(ServerWebExchange exchange) {
                return exchange.getAttribute(TRACE_SPAN_WITHOUT_PARENT) != null;
            }
        }
    }
}

