/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder.kafka.streams;

import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.kstream.GlobalKTable;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.KTable;
import org.springframework.beans.BeansException;
import org.springframework.cloud.stream.binder.ConsumerProperties;
import org.springframework.cloud.stream.binder.ProducerProperties;
import org.springframework.cloud.stream.binder.kafka.streams.SerdeResolverUtils;
import org.springframework.cloud.stream.binder.kafka.streams.properties.KafkaStreamsBinderConfigurationProperties;
import org.springframework.cloud.stream.binder.kafka.streams.properties.KafkaStreamsConsumerProperties;
import org.springframework.cloud.stream.binder.kafka.streams.properties.KafkaStreamsProducerProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.ResolvableType;
import org.springframework.util.StringUtils;

public class KeyValueSerdeResolver
implements ApplicationContextAware {
    private final Map<String, Object> streamConfigGlobalProperties;
    private final KafkaStreamsBinderConfigurationProperties binderConfigurationProperties;
    private ConfigurableApplicationContext context;

    KeyValueSerdeResolver(Map<String, Object> streamConfigGlobalProperties, KafkaStreamsBinderConfigurationProperties binderConfigurationProperties) {
        this.streamConfigGlobalProperties = streamConfigGlobalProperties;
        this.binderConfigurationProperties = binderConfigurationProperties;
    }

    public Serde<?> getInboundKeySerde(KafkaStreamsConsumerProperties extendedConsumerProperties) {
        String keySerdeString = extendedConsumerProperties.getKeySerde();
        return this.getKeySerde(keySerdeString, extendedConsumerProperties.getConfiguration());
    }

    public Serde<?> getInboundKeySerde(KafkaStreamsConsumerProperties extendedConsumerProperties, ResolvableType resolvableType) {
        String keySerdeString = extendedConsumerProperties.getKeySerde();
        return this.getKeySerde(keySerdeString, resolvableType, extendedConsumerProperties.getConfiguration());
    }

    public Serde<?> getInboundValueSerde(ConsumerProperties consumerProperties, KafkaStreamsConsumerProperties extendedConsumerProperties) {
        Serde<?> valueSerde;
        String valueSerdeString = extendedConsumerProperties.getValueSerde();
        try {
            valueSerde = consumerProperties != null && consumerProperties.isUseNativeDecoding() ? this.getValueSerde(valueSerdeString, extendedConsumerProperties.getConfiguration()) : Serdes.ByteArray();
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalStateException("Serde class not found: ", ex);
        }
        return valueSerde;
    }

    public Serde<?> getInboundValueSerde(ConsumerProperties consumerProperties, KafkaStreamsConsumerProperties extendedConsumerProperties, ResolvableType resolvableType) {
        Serde<?> valueSerde;
        String valueSerdeString = extendedConsumerProperties.getValueSerde();
        try {
            valueSerde = consumerProperties != null && consumerProperties.isUseNativeDecoding() ? this.getValueSerde(valueSerdeString, resolvableType, extendedConsumerProperties.getConfiguration()) : Serdes.ByteArray();
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalStateException("Serde class not found: ", ex);
        }
        return valueSerde;
    }

    public Serde<?> getOuboundKeySerde(KafkaStreamsProducerProperties properties) {
        return this.getKeySerde(properties.getKeySerde(), properties.getConfiguration());
    }

    public Serde<?> getOuboundKeySerde(KafkaStreamsProducerProperties properties, ResolvableType resolvableType) {
        return this.getKeySerde(properties.getKeySerde(), resolvableType, properties.getConfiguration());
    }

    public Serde<?> getOutboundValueSerde(ProducerProperties producerProperties, KafkaStreamsProducerProperties kafkaStreamsProducerProperties) {
        Serde<?> valueSerde;
        try {
            valueSerde = producerProperties.isUseNativeEncoding() ? this.getValueSerde(kafkaStreamsProducerProperties.getValueSerde(), kafkaStreamsProducerProperties.getConfiguration()) : Serdes.ByteArray();
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalStateException("Serde class not found: ", ex);
        }
        return valueSerde;
    }

    public Serde<?> getOutboundValueSerde(ProducerProperties producerProperties, KafkaStreamsProducerProperties kafkaStreamsProducerProperties, ResolvableType resolvableType) {
        Serde<?> valueSerde;
        try {
            valueSerde = producerProperties.isUseNativeEncoding() ? this.getValueSerde(kafkaStreamsProducerProperties.getValueSerde(), resolvableType, kafkaStreamsProducerProperties.getConfiguration()) : Serdes.ByteArray();
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalStateException("Serde class not found: ", ex);
        }
        return valueSerde;
    }

    public Serde<?> getStateStoreKeySerde(String keySerdeString) {
        return this.getKeySerde(keySerdeString, null);
    }

    public Serde<?> getStateStoreValueSerde(String valueSerdeString) {
        try {
            return this.getValueSerde(valueSerdeString, null);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalStateException("Serde class not found: ", ex);
        }
    }

    private Serde<?> getKeySerde(String keySerdeString, Map<String, ?> extendedConfiguration) {
        Serde keySerde;
        try {
            keySerde = StringUtils.hasText((String)keySerdeString) ? (Serde)Utils.newInstance((String)keySerdeString, Serde.class) : this.getFallbackSerde("default.key.serde");
            keySerde.configure(this.combineStreamConfigProperties(extendedConfiguration), true);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalStateException("Serde class not found: ", ex);
        }
        return keySerde;
    }

    private Serde<?> getKeySerde(String keySerdeString, ResolvableType resolvableType, Map<String, ?> extendedConfiguration) {
        Serde<?> keySerde;
        try {
            if (StringUtils.hasText((String)keySerdeString)) {
                keySerde = (Serde)Utils.newInstance((String)keySerdeString, Serde.class);
            } else {
                keySerde = Serdes.ByteArray();
                if (resolvableType != null && (this.isResolvalbeKafkaStreamsType(resolvableType) || this.isResolvableKStreamArrayType(resolvableType))) {
                    ResolvableType targetType = resolvableType.isArray() ? resolvableType.getComponentType().getGeneric(new int[]{0}) : resolvableType.getGeneric(new int[]{0});
                    Serde<?> fallbackSerde = this.getFallbackSerde("default.key.serde");
                    keySerde = SerdeResolverUtils.resolveForType(this.context, targetType, fallbackSerde);
                }
            }
            keySerde.configure(this.combineStreamConfigProperties(extendedConfiguration), true);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalStateException("Serde class not found: ", ex);
        }
        return keySerde;
    }

    private boolean isResolvableKStreamArrayType(ResolvableType resolvableType) {
        return resolvableType.isArray() && KStream.class.isAssignableFrom(resolvableType.getComponentType().getRawClass());
    }

    private boolean isResolvalbeKafkaStreamsType(ResolvableType resolvableType) {
        return resolvableType.getRawClass() != null && (KStream.class.isAssignableFrom(resolvableType.getRawClass()) || KTable.class.isAssignableFrom(resolvableType.getRawClass()) || GlobalKTable.class.isAssignableFrom(resolvableType.getRawClass()));
    }

    private Serde<?> getValueSerde(String valueSerdeString, Map<String, ?> extendedConfiguration) throws ClassNotFoundException {
        Serde valueSerde = StringUtils.hasText((String)valueSerdeString) ? (Serde)Utils.newInstance((String)valueSerdeString, Serde.class) : this.getFallbackSerde("default.value.serde");
        valueSerde.configure(this.combineStreamConfigProperties(extendedConfiguration), false);
        return valueSerde;
    }

    private Serde<?> getFallbackSerde(String s) throws ClassNotFoundException {
        return this.binderConfigurationProperties.getConfiguration().containsKey(s) ? (Serde)Utils.newInstance((String)((String)this.binderConfigurationProperties.getConfiguration().get(s)), Serde.class) : Serdes.ByteArray();
    }

    private Serde<?> getValueSerde(String valueSerdeString, ResolvableType resolvableType, Map<String, ?> extendedConfiguration) throws ClassNotFoundException {
        Serde<?> valueSerde;
        if (StringUtils.hasText((String)valueSerdeString)) {
            valueSerde = (Serde)Utils.newInstance((String)valueSerdeString, Serde.class);
        } else {
            valueSerde = Serdes.ByteArray();
            if (resolvableType != null && (this.isResolvalbeKafkaStreamsType(resolvableType) || this.isResolvableKStreamArrayType(resolvableType))) {
                ResolvableType targetType = resolvableType.isArray() ? resolvableType.getComponentType().getGeneric(new int[]{1}) : resolvableType.getGeneric(new int[]{1});
                Serde<?> fallbackSerde = this.getFallbackSerde("default.value.serde");
                valueSerde = SerdeResolverUtils.resolveForType(this.context, targetType, fallbackSerde);
            }
        }
        valueSerde.configure(this.combineStreamConfigProperties(extendedConfiguration), false);
        return valueSerde;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = (ConfigurableApplicationContext)applicationContext;
    }

    private Map<String, ?> combineStreamConfigProperties(Map<String, ?> extendedConfiguration) {
        if (extendedConfiguration != null && !extendedConfiguration.isEmpty()) {
            HashMap<String, Object> streamConfiguration = new HashMap<String, Object>(this.streamConfigGlobalProperties);
            streamConfiguration.putAll(extendedConfiguration);
            return streamConfiguration;
        }
        return this.streamConfigGlobalProperties;
    }
}

