/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapping.context;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.core.TypeInformation;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.lang.Contract;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

class DefaultPersistentPropertyPath<P extends PersistentProperty<P>>
implements PersistentPropertyPath<P> {
    private static final Converter<PersistentProperty<?>, String> DEFAULT_CONVERTER = PersistentProperty::getName;
    private static final String DEFAULT_DELIMITER = ".";
    private final List<P> properties;

    public DefaultPersistentPropertyPath(List<P> properties) {
        Assert.notNull(properties, (String)"Properties must not be null");
        this.properties = properties;
    }

    static <T extends PersistentProperty<T>> DefaultPersistentPropertyPath<T> empty() {
        return new DefaultPersistentPropertyPath(Collections.emptyList());
    }

    DefaultPersistentPropertyPath<P> append(P property) {
        Assert.notNull(property, (String)"Property must not be null");
        if (this.isEmpty()) {
            return new DefaultPersistentPropertyPath<P>(Collections.singletonList(property));
        }
        Class<?> leafPropertyType = this.getLeafProperty().getActualType();
        Assert.isTrue((boolean)property.getOwner().getType().equals(leafPropertyType), () -> String.format("Cannot append property %s to type %s", property.getName(), leafPropertyType.getName()));
        ArrayList<P> properties = new ArrayList<P>(this.properties);
        properties.add(property);
        return new DefaultPersistentPropertyPath<P>(properties);
    }

    @Override
    public String toDotPath() {
        return this.toPath(DEFAULT_DELIMITER, DEFAULT_CONVERTER);
    }

    @Override
    public String toDotPath(Converter<? super P, String> converter) {
        return this.toPath(DEFAULT_DELIMITER, converter);
    }

    @Override
    public String toPath(String delimiter) {
        return this.toPath(delimiter, DEFAULT_CONVERTER);
    }

    @Override
    public String toPath(String delimiter, Converter<? super P, String> converter) {
        Assert.hasText((String)delimiter, (String)"Delimiter must not be null or empty");
        Assert.notNull(converter, (String)"Converter must not be null");
        StringBuilder builder = null;
        for (PersistentProperty property : this.properties) {
            String converted = (String)converter.convert((Object)property);
            if (ObjectUtils.isEmpty((Object)converted)) continue;
            if (builder == null) {
                builder = new StringBuilder();
            }
            if (!builder.isEmpty()) {
                builder.append(delimiter);
            }
            builder.append(converted);
        }
        return builder == null ? "" : builder.toString();
    }

    @Override
    public P getLeafProperty() {
        Assert.state((!this.properties.isEmpty() ? 1 : 0) != 0, (String)"Empty PersistentPropertyPath should not exist");
        return (P)((PersistentProperty)this.properties.get(this.properties.size() - 1));
    }

    @Override
    public P getBaseProperty() {
        Assert.state((!this.properties.isEmpty() ? 1 : 0) != 0, (String)"Empty PersistentPropertyPath should not exist");
        return (P)((PersistentProperty)this.properties.get(0));
    }

    @Override
    public boolean isBasePathOf(PersistentPropertyPath<P> path) {
        Assert.notNull(path, (String)"PersistentPropertyPath must not be null");
        Iterator iterator = path.iterator();
        for (PersistentProperty property : this) {
            if (!iterator.hasNext()) {
                return false;
            }
            PersistentProperty reference = (PersistentProperty)iterator.next();
            if (property.equals(reference)) continue;
            return false;
        }
        return true;
    }

    @Override
    public PersistentPropertyPath<P> getExtensionForBaseOf(PersistentPropertyPath<P> base) {
        if (!base.isBasePathOf(this)) {
            return this;
        }
        return new DefaultPersistentPropertyPath<P>(this.properties.subList(base.getLength(), this.getLength()));
    }

    @Override
    public @Nullable PersistentPropertyPath<P> getParentPath() {
        int size = this.properties.size();
        return size == 1 ? null : new DefaultPersistentPropertyPath<P>(this.properties.subList(0, size - 1));
    }

    @Override
    public int getLength() {
        return this.properties.size();
    }

    @Override
    public Iterator<P> iterator() {
        return this.properties.iterator();
    }

    @Contract(value="null -> false")
    public boolean containsPropertyOfType(@Nullable TypeInformation<?> type) {
        if (type == null) {
            return false;
        }
        for (PersistentProperty property : this.properties) {
            if (!type.equals(property.getTypeInformation().getActualType())) continue;
            return true;
        }
        return false;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultPersistentPropertyPath)) {
            return false;
        }
        DefaultPersistentPropertyPath that = (DefaultPersistentPropertyPath)o;
        return ObjectUtils.nullSafeEquals(this.properties, that.properties);
    }

    public int hashCode() {
        return ObjectUtils.nullSafeHashCode(this.properties);
    }

    public String toString() {
        return this.toDotPath();
    }
}

