/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionShortcut;
import org.springframework.beans.BeanInstantiationException;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.CachePut;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.cache.annotation.Caching;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.type.MethodMetadata;
import org.springframework.data.gemfire.config.annotation.support.BeanDefinitionRegistryPostProcessorSupport;
import org.springframework.data.gemfire.config.annotation.support.GemFireCacheTypeAwareRegionFactoryBean;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

@Configuration
public class CachingDefinedRegionsConfiguration {
    private static final Class[] CLASS_CACHE_ANNOTATION_TYPES;
    private static final Class[] METHOD_CACHE_ANNOTATION_TYPES;
    private static final Set<Integer> INFRASTRUCTURE_ROLES;
    private static final String ORG_SPRINGFRAMEWORK_DATA_GEMFIRE_PACKAGE = "org.springframework.data.gemfire";
    private static final String ORG_SPRINGFRAMEWORK_PACKAGE = "org.springframework";

    @Bean
    public BeanDefinitionRegistryPostProcessor cacheAbstractionAnnotationsRegionBeanDefinitionRegistrar() {
        return new BeanDefinitionRegistryPostProcessorSupport(){

            @Override
            public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
                CachingDefinedRegionsConfiguration.this.registerBeanDefinitions(registry);
            }
        };
    }

    @Bean
    public BeanPostProcessor cacheAbstractionAnnotationsRegionBeanRegistrar(final ConfigurableBeanFactory beanFactory) {
        return new BeanPostProcessor(){

            @Nullable
            public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
                if (CachingDefinedRegionsConfiguration.this.isNotInfrastructureBean(bean)) {
                    CachingDefinedRegionsConfiguration.this.registerRegionBeans(CachingDefinedRegionsConfiguration.this.collectCacheNames(bean.getClass()), beanFactory);
                }
                return bean;
            }
        };
    }

    void registerBeanDefinitions(BeanDefinitionRegistry registry) {
        for (String beanName : registry.getBeanDefinitionNames()) {
            BeanDefinition beanDefinition = registry.getBeanDefinition(beanName);
            if (!this.isNotInfrastructureBean(beanDefinition)) continue;
            this.resolveBeanClass(beanDefinition, registry).ifPresent(beanClass -> this.registerRegionBeanDefinitions(this.collectCacheNames((Class<?>)beanClass), registry));
        }
    }

    private boolean isNotInfrastructureBean(Object bean) {
        return this.isNotInfrastructureClass(bean.getClass().getName());
    }

    boolean isNotInfrastructureBean(BeanDefinition beanDefinition) {
        return this.isNotInfrastructureRole(beanDefinition) && this.isNotInfrastructureClass(beanDefinition);
    }

    boolean isNotInfrastructureClass(BeanDefinition beanDefinition) {
        return this.resolveBeanClassName(beanDefinition).filter(this::isNotInfrastructureClass).isPresent();
    }

    boolean isNotInfrastructureClass(String className) {
        return className.startsWith(ORG_SPRINGFRAMEWORK_DATA_GEMFIRE_PACKAGE) || !className.startsWith(ORG_SPRINGFRAMEWORK_PACKAGE);
    }

    boolean isNotInfrastructureRole(BeanDefinition beanDefinition) {
        return !INFRASTRUCTURE_ROLES.contains(beanDefinition.getRole());
    }

    boolean isUserLevelMethod(Method method) {
        return Optional.ofNullable(method).filter(ClassUtils::isUserLevelMethod).filter(it -> !Object.class.equals(it.getDeclaringClass())).isPresent();
    }

    private Set<String> collectCacheNames(Class<?> type) {
        HashSet<String> cacheNames = new HashSet<String>();
        cacheNames.addAll(this.collectCachingCacheNames(type));
        cacheNames.addAll(this.collectCacheNames(type, CLASS_CACHE_ANNOTATION_TYPES));
        Arrays.stream(type.getMethods()).forEach(method -> {
            if (this.isUserLevelMethod((Method)method)) {
                cacheNames.addAll(this.collectCachingCacheNames((AnnotatedElement)method));
                cacheNames.addAll(this.collectCacheNames((AnnotatedElement)method, METHOD_CACHE_ANNOTATION_TYPES));
            }
        });
        return cacheNames;
    }

    Set<String> collectCacheNames(AnnotatedElement annotatedElement, Class<? extends Annotation> ... annotationTypes) {
        Stream cacheNames = Arrays.stream(ArrayUtils.nullSafeArray(annotationTypes, Class.class)).map(annotationType -> this.resolveAnnotation(annotatedElement, (Class)annotationType)).flatMap(annotation -> this.collectCacheNames((Annotation)annotation).stream());
        return cacheNames.collect(Collectors.toSet());
    }

    private Set<String> collectCacheNames(Annotation annotation) {
        return Optional.ofNullable(annotation).map(AnnotationUtils::getAnnotationAttributes).map(annotationAttributes -> (String[])annotationAttributes.get("cacheNames")).map(CollectionUtils::asSet).orElse(Collections.emptySet());
    }

    private Set<String> collectCachingCacheNames(AnnotatedElement annotatedElement) {
        HashSet<String> cacheNames = new HashSet<String>();
        Optional.ofNullable(this.resolveAnnotation(annotatedElement, Caching.class)).ifPresent(caching -> {
            cacheNames.addAll(Arrays.stream(ArrayUtils.nullSafeArray(caching.cacheable(), Cacheable.class)).flatMap(cacheable -> this.collectCacheNames((Annotation)cacheable).stream()).collect(Collectors.toSet()));
            cacheNames.addAll(Arrays.stream(ArrayUtils.nullSafeArray(caching.evict(), CacheEvict.class)).flatMap(cacheable -> this.collectCacheNames((Annotation)cacheable).stream()).collect(Collectors.toSet()));
            cacheNames.addAll(Arrays.stream(ArrayUtils.nullSafeArray(caching.put(), CachePut.class)).flatMap(cacheable -> this.collectCacheNames((Annotation)cacheable).stream()).collect(Collectors.toSet()));
        });
        return cacheNames;
    }

    private BeanDefinitionRegistry registerRegionBeanDefinitions(Set<String> cacheNames, BeanDefinitionRegistry registry) {
        boolean containsGemFirePoolBeanDefinition = registry.containsBeanDefinition("gemfirePool");
        cacheNames.forEach(cacheName -> {
            if (!registry.containsBeanDefinition(cacheName)) {
                BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(GemFireCacheTypeAwareRegionFactoryBean.class);
                builder.addPropertyReference("cache", "gemfireCache");
                if (!containsGemFirePoolBeanDefinition) {
                    builder.addPropertyValue("poolName", (Object)"DEFAULT");
                }
                builder.addPropertyValue("regionName", cacheName);
                builder.addPropertyValue("serverRegionShortcut", (Object)RegionShortcut.PARTITION);
                registry.registerBeanDefinition(cacheName, (BeanDefinition)builder.getBeanDefinition());
            }
        });
        return registry;
    }

    private ConfigurableBeanFactory registerRegionBeans(Set<String> cacheNames, ConfigurableBeanFactory beanFactory) {
        boolean containsGemFirePoolBean = beanFactory.containsBean("gemfirePool");
        cacheNames.forEach(cacheName -> {
            if (!beanFactory.containsBean(cacheName)) {
                try {
                    GemFireCacheTypeAwareRegionFactoryBean regionFactoryBean = new GemFireCacheTypeAwareRegionFactoryBean();
                    regionFactoryBean.setCache((GemFireCache)beanFactory.getBean("gemfireCache", GemFireCache.class));
                    if (!containsGemFirePoolBean) {
                        regionFactoryBean.setPoolName("DEFAULT");
                    }
                    regionFactoryBean.setRegionName((String)cacheName);
                    regionFactoryBean.setServerRegionShortcut(RegionShortcut.PARTITION);
                    regionFactoryBean.afterPropertiesSet();
                    Optional.ofNullable(regionFactoryBean.getObject()).ifPresent(region -> beanFactory.registerSingleton(cacheName, region));
                }
                catch (Exception cause) {
                    throw new BeanInstantiationException(Region.class, String.format("Failed to create Region for cache [%s]", cacheName), (Throwable)cause);
                }
            }
        });
        return beanFactory;
    }

    <A extends Annotation> A resolveAnnotation(AnnotatedElement annotatedElement, Class<A> annotationType) {
        return (A)(annotatedElement instanceof Class ? AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)annotatedElement, annotationType) : AnnotationUtils.findAnnotation((AnnotatedElement)annotatedElement, annotationType));
    }

    Optional<Class<?>> resolveBeanClass(BeanDefinition beanDefinition, BeanDefinitionRegistry registry) {
        return this.resolveBeanClass(beanDefinition, this.resolveBeanClassLoader(registry));
    }

    private Optional<Class<?>> resolveBeanClass(BeanDefinition beanDefinition, ClassLoader classLoader) {
        Class beanClass;
        Class clazz = beanClass = beanDefinition instanceof AbstractBeanDefinition ? this.safeResolveType(() -> ((AbstractBeanDefinition)beanDefinition).resolveBeanClass(classLoader)) : null;
        if (beanClass == null) {
            beanClass = this.resolveBeanClassName(beanDefinition).map(beanClassName -> this.safeResolveType(() -> ClassUtils.forName((String)beanClassName, (ClassLoader)classLoader))).orElse(null);
        }
        return Optional.ofNullable(beanClass);
    }

    ClassLoader resolveBeanClassLoader(BeanDefinitionRegistry registry) {
        return registry instanceof ConfigurableBeanFactory ? ((ConfigurableBeanFactory)registry).getBeanClassLoader() : Thread.currentThread().getContextClassLoader();
    }

    Optional<String> resolveBeanClassName(BeanDefinition beanDefinition) {
        Optional<String> beanClassName = Optional.ofNullable(beanDefinition.getBeanClassName()).filter(StringUtils::hasText);
        if (!beanClassName.isPresent()) {
            beanClassName = Optional.of(beanDefinition).filter(it -> StringUtils.hasText((String)it.getFactoryMethodName())).filter(it -> it instanceof AnnotatedBeanDefinition).map(it -> ((AnnotatedBeanDefinition)it).getFactoryMethodMetadata()).map(MethodMetadata::getReturnTypeName);
        }
        return beanClassName;
    }

    Class<?> safeResolveType(TypeResolver typeResolver) {
        try {
            return typeResolver.resolve();
        }
        catch (ClassNotFoundException cause) {
            return null;
        }
    }

    static {
        METHOD_CACHE_ANNOTATION_TYPES = ArrayUtils.asArray(Cacheable.class, CacheEvict.class, CachePut.class);
        ArrayList<Class<CacheConfig>> annotationTypes = new ArrayList<Class<CacheConfig>>();
        Collections.addAll(annotationTypes, METHOD_CACHE_ANNOTATION_TYPES);
        annotationTypes.add(CacheConfig.class);
        CLASS_CACHE_ANNOTATION_TYPES = annotationTypes.toArray(new Class[annotationTypes.size()]);
        INFRASTRUCTURE_ROLES = CollectionUtils.asSet(2, 1);
    }

    static interface TypeResolver {
        public Class<?> resolve() throws ClassNotFoundException;
    }
}

