/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.repository.support;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.OffsetScrollPosition;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.ScrollPosition;
import org.springframework.data.domain.Sort;
import org.springframework.data.domain.Window;
import org.springframework.data.jdbc.core.JdbcAggregateOperations;
import org.springframework.data.jdbc.repository.support.FluentQuerySupport;
import org.springframework.data.jdbc.repository.support.ScrollDelegate;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.relational.core.query.Query;
import org.springframework.data.relational.repository.query.RelationalExampleMapper;
import org.springframework.data.support.PageableExecutionUtils;
import org.springframework.util.Assert;

class FetchableFluentQueryByExample<S, R>
extends FluentQuerySupport<S, R> {
    private final RelationalExampleMapper exampleMapper;
    private final JdbcAggregateOperations entityOperations;
    private final ProjectionFactory projectionFactory;

    FetchableFluentQueryByExample(Example<S> example, Class<R> resultType, RelationalExampleMapper exampleMapper, JdbcAggregateOperations entityOperations, ProjectionFactory projectionFactory) {
        this(example, Sort.unsorted(), 0, resultType, Collections.emptyList(), exampleMapper, entityOperations, projectionFactory);
    }

    FetchableFluentQueryByExample(Example<S> example, Sort sort, int limit, Class<R> resultType, List<String> fieldsToInclude, RelationalExampleMapper exampleMapper, JdbcAggregateOperations entityOperations, ProjectionFactory projectionFactory) {
        super(example, sort, limit, resultType, fieldsToInclude, projectionFactory, entityOperations.getConverter());
        this.exampleMapper = exampleMapper;
        this.entityOperations = entityOperations;
        this.projectionFactory = projectionFactory;
    }

    public R oneValue() {
        return (R)this.entityOperations.findOne(this.createQuery(), this.getExampleType()).map(item -> this.getConversionFunction().apply(item)).get();
    }

    public R firstValue() {
        return this.getConversionFunction().apply(this.entityOperations.findAll(this.createQuery().sort(this.getSort()), this.getExampleType()).iterator().next());
    }

    public List<R> all() {
        return this.findAll(this.createQuery().sort(this.getSort()));
    }

    private List<R> findAll(Query query) {
        List raw = this.entityOperations.findAll(query, this.getExampleType());
        return this.mapContent(raw);
    }

    public Window<R> scroll(ScrollPosition scrollPosition) {
        Assert.notNull((Object)scrollPosition, (String)"ScrollPosition must not be null");
        if (scrollPosition instanceof OffsetScrollPosition) {
            OffsetScrollPosition osp = (OffsetScrollPosition)scrollPosition;
            Query query = this.createQuery().sort(this.getSort());
            if (!osp.isInitial()) {
                query = query.offset(osp.getOffset() + 1L);
            }
            if (this.getLimit() > 0) {
                query = query.limit(this.getLimit());
            }
            return ScrollDelegate.scroll(query, this::findAll, (ScrollPosition)osp);
        }
        return super.scroll(scrollPosition);
    }

    public Page<R> page(Pageable pageable) {
        Query contentQuery = this.createQuery(p -> p.with(pageable));
        List content = this.entityOperations.findAll(contentQuery, this.getExampleType());
        List<R> result = this.mapContent(content);
        return PageableExecutionUtils.getPage(result, (Pageable)pageable, () -> this.entityOperations.count(this.createQuery(), this.getExampleType()));
    }

    private List<R> mapContent(List<S> content) {
        Function conversionFunction = this.getConversionFunction();
        if (conversionFunction == Function.identity()) {
            return content;
        }
        ArrayList result = new ArrayList(content.size());
        for (S s : content) {
            result.add(conversionFunction.apply(s));
        }
        return result;
    }

    public Stream<R> stream() {
        return this.entityOperations.streamAll(this.createQuery().sort(this.getSort()), this.getExampleType()).map(this.getConversionFunction());
    }

    public long count() {
        return this.entityOperations.count(this.createQuery(), this.getExampleType());
    }

    public boolean exists() {
        return this.entityOperations.exists(this.createQuery(), this.getExampleType());
    }

    private Query createQuery() {
        return this.createQuery(UnaryOperator.identity());
    }

    private Query createQuery(UnaryOperator<Query> queryCustomizer) {
        Query query = this.exampleMapper.getMappedExample(this.getExample());
        if (!this.getFieldsToInclude().isEmpty()) {
            query = query.columns(this.getFieldsToInclude().toArray(new String[0]));
        }
        query = query.limit(this.getLimit());
        query = (Query)queryCustomizer.apply(query);
        return query;
    }

    @Override
    protected <R> FluentQuerySupport<S, R> create(Example<S> example, Sort sort, int limit, Class<R> resultType, List<String> fieldsToInclude) {
        return new FetchableFluentQueryByExample<S, R>(example, sort, limit, resultType, fieldsToInclude, this.exampleMapper, this.entityOperations, this.projectionFactory);
    }
}

