/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.convert;

import com.mongodb.BasicDBList;
import com.mongodb.DBObject;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.springframework.data.convert.DefaultTypeMapper;
import org.springframework.data.convert.SimpleTypeInformationMapper;
import org.springframework.data.convert.TypeAliasAccessor;
import org.springframework.data.convert.TypeInformationMapper;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.core.convert.MongoTypeMapper;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMongoTypeMapper
extends DefaultTypeMapper<DBObject>
implements MongoTypeMapper {
    public static final String DEFAULT_TYPE_KEY = "_class";
    private static final TypeInformation<List> LIST_TYPE_INFO = ClassTypeInformation.from(List.class);
    private static final TypeInformation<Map> MAP_TYPE_INFO = ClassTypeInformation.from(Map.class);
    private String typeKey = "_class";

    public DefaultMongoTypeMapper() {
        this(DEFAULT_TYPE_KEY, Arrays.asList(SimpleTypeInformationMapper.INSTANCE));
    }

    public DefaultMongoTypeMapper(String typeKey) {
        super((TypeAliasAccessor)new DBObjectTypeAliasAccessor(typeKey));
        this.typeKey = typeKey;
    }

    public DefaultMongoTypeMapper(String typeKey, MappingContext<? extends PersistentEntity<?, ?>, ?> mappingContext) {
        super((TypeAliasAccessor)new DBObjectTypeAliasAccessor(typeKey), mappingContext, Arrays.asList(SimpleTypeInformationMapper.INSTANCE));
        this.typeKey = typeKey;
    }

    public DefaultMongoTypeMapper(String typeKey, List<? extends TypeInformationMapper> mappers) {
        super((TypeAliasAccessor)new DBObjectTypeAliasAccessor(typeKey), mappers);
        this.typeKey = typeKey;
    }

    @Override
    public boolean isTypeKey(String key) {
        return this.typeKey == null ? false : this.typeKey.equals(key);
    }

    protected TypeInformation<?> getFallbackTypeFor(DBObject source) {
        return source instanceof BasicDBList ? LIST_TYPE_INFO : MAP_TYPE_INFO;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DBObjectTypeAliasAccessor
    implements TypeAliasAccessor<DBObject> {
        private final String typeKey;

        public DBObjectTypeAliasAccessor(String typeKey) {
            this.typeKey = typeKey;
        }

        public Object readAliasFrom(DBObject source) {
            if (source instanceof BasicDBList) {
                return null;
            }
            return source.get(this.typeKey);
        }

        public void writeTypeTo(DBObject sink, Object alias) {
            if (this.typeKey != null) {
                sink.put(this.typeKey, alias);
            }
        }
    }
}

