/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.geo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.springframework.data.mongodb.core.geo.Point;
import org.springframework.data.mongodb.core.geo.Shape;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Polygon
implements Shape,
Iterable<Point> {
    private final List<Point> points;

    public Polygon(Point x, Point y, Point z, Point ... others) {
        Assert.notNull((Object)x);
        Assert.notNull((Object)y);
        Assert.notNull((Object)z);
        Assert.notNull((Object)others);
        this.points = new ArrayList<Point>(3 + others.length);
        this.points.addAll(Arrays.asList(x, y, z));
        this.points.addAll(Arrays.asList(others));
    }

    public List<List<Double>> asList() {
        ArrayList<List<Double>> result = new ArrayList<List<Double>>();
        for (Point point : this.points) {
            result.add(point.asList());
        }
        return result;
    }

    @Override
    public String getCommand() {
        return "$polygon";
    }

    @Override
    public Iterator<Point> iterator() {
        return this.points.iterator();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        Polygon that = (Polygon)obj;
        return ((Object)this.points).equals(that.points);
    }

    public int hashCode() {
        return ((Object)this.points).hashCode();
    }
}

