/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.ReadPreference;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import java.util.function.Function;
import org.bson.Document;
import org.springframework.data.mongodb.core.ReadPreferenceAware;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public interface CursorPreparer
extends ReadPreferenceAware {
    public static final CursorPreparer NO_OP_PREPARER = iterable -> iterable;

    public FindIterable<Document> prepare(FindIterable<Document> var1);

    default public FindIterable<Document> initiateFind(MongoCollection<Document> collection, Function<MongoCollection<Document>, FindIterable<Document>> find) {
        Assert.notNull(collection, (String)"Collection must not be null!");
        Assert.notNull(find, (String)"Find function must not be null!");
        if (this.hasReadPreference()) {
            collection = collection.withReadPreference(this.getReadPreference());
        }
        return this.prepare(find.apply(collection));
    }

    @Override
    @Nullable
    default public ReadPreference getReadPreference() {
        return null;
    }
}

