/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.fieldaccess;

import org.springframework.beans.factory.annotation.Configurable;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.data.neo4j.fieldaccess.FieldAccessor;
import org.springframework.data.neo4j.fieldaccess.FieldAccessorFactory;
import org.springframework.data.neo4j.fieldaccess.PropertyConverter;
import org.springframework.data.neo4j.fieldaccess.PropertyFieldAccessorFactory;
import org.springframework.data.neo4j.mapping.MappingPolicy;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.data.neo4j.support.conversion.GenericObjectToObjectConverter;

@Configurable
public class GenericNodePropertyFieldAccessorFactory
implements FieldAccessorFactory {
    private final Neo4jTemplate template;

    public GenericNodePropertyFieldAccessorFactory(Neo4jTemplate template) {
        this.template = template;
    }

    @Override
    public boolean accept(Neo4jPersistentProperty property) {
        return property.getType() == Object.class && !property.isTransient();
    }

    @Override
    public FieldAccessor forField(Neo4jPersistentProperty property) {
        return new GenericNodePropertyFieldAccessor(property, this.template);
    }

    public static class GenericNodePropertyFieldAccessor
    extends PropertyFieldAccessorFactory.PropertyFieldAccessor {
        private final PropertyConverter propertyConverter;

        public GenericNodePropertyFieldAccessor(Neo4jPersistentProperty property, Neo4jTemplate template) {
            super(template, property);
            GenericConversionService genericConversionService = new GenericConversionService();
            genericConversionService.addConverter((GenericConverter)new GenericObjectToObjectConverter());
            this.propertyConverter = new PropertyConverter((ConversionService)genericConversionService, property);
        }

        @Override
        public Object setValue(Object entity, Object newVal, MappingPolicy mappingPolicy) {
            Object value = this.propertyConverter.isObjectOrSupportedType(newVal, this.property) ? newVal : this.propertyConverter.serializePropertyValue(newVal);
            super.setValue(entity, value, mappingPolicy);
            return newVal;
        }

        @Override
        public Object doGetValue(Object entity) {
            Object ret = super.doGetValue(entity);
            if (this.propertyConverter.isObjectOrSupportedType(ret, this.property)) {
                return ret;
            }
            return this.propertyConverter.deserializePropertyValue(ret);
        }

        @Override
        protected Object convertSimplePropertyValue(Object value) {
            return value;
        }
    }
}

