/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.helpers.collection.IteratorUtil;
import org.springframework.data.neo4j.repository.query.IndexBasedStartClause;
import org.springframework.data.neo4j.repository.query.PartInfo;
import org.springframework.data.neo4j.repository.query.QueryTemplates;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.data.repository.query.Parameter;

public class FullTextIndexBasedStartClause
extends IndexBasedStartClause {
    public FullTextIndexBasedStartClause(PartInfo partInfo) {
        super(partInfo);
    }

    public FullTextIndexBasedStartClause(List<PartInfo> partInfos) {
        super(partInfos.get(0));
        int i = 0;
        for (PartInfo partInfo : partInfos) {
            if (i != 0) {
                this.merge(partInfo);
            }
            ++i;
        }
    }

    public String toString() {
        PartInfo partInfo = this.getPartInfo();
        String identifier = partInfo.getIdentifier();
        String indexName = partInfo.getIndexName();
        int parameterIndex = partInfo.getParameterIndex();
        return String.format(QueryTemplates.START_CLAUSE_INDEX_QUERY, identifier, indexName, parameterIndex);
    }

    @Override
    public Map<Parameter, Object> resolveParameters(Map<Parameter, Object> parameters, Neo4jTemplate template) {
        Map<Parameter, PartInfo> myParameters = this.findMyParameters(parameters.keySet());
        LinkedHashMap<Parameter, Object> result = new LinkedHashMap<Parameter, Object>(parameters);
        result.keySet().removeAll(myParameters.keySet());
        Map<PartInfo, Object> values = this.matchToPartsAndConvert(myParameters, parameters, template);
        Parameter firstParam = (Parameter)IteratorUtil.first(myParameters.keySet());
        result.put(firstParam, this.renderQuery(values));
        return result;
    }

    protected String renderQuery(Map<PartInfo, Object> values) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<PartInfo, Object> entry : values.entrySet()) {
            if (sb.length() > 0) {
                sb.append(" AND ");
            }
            PartInfo partInfo = entry.getKey();
            Object value = entry.getValue();
            sb.append(QueryTemplates.formatIndexQuery(partInfo, value));
        }
        return sb.toString();
    }
}

