/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.UnsatisfiedResolutionException;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.ProcessBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.neo4j.core.GraphDatabase;
import org.springframework.data.neo4j.repository.cdi.Neo4jCdiRepositoryBean;
import org.springframework.data.neo4j.support.mapping.Neo4jMappingContext;
import org.springframework.data.repository.cdi.CdiRepositoryBean;
import org.springframework.data.repository.cdi.CdiRepositoryExtensionSupport;

public class Neo4jCdiRepositoryExtension
extends CdiRepositoryExtensionSupport {
    private static final Logger LOG = LoggerFactory.getLogger(Neo4jCdiRepositoryExtension.class);
    private final Map<Set<Annotation>, Bean<GraphDatabase>> graphDatabases = new HashMap<Set<Annotation>, Bean<GraphDatabase>>();

    public Neo4jCdiRepositoryExtension() {
        LOG.info("Activating CDI extension for Spring Data Neo4j repositories.");
    }

    <X> void processBean(@Observes ProcessBean<X> processBean) {
        Bean bean = processBean.getBean();
        for (Type type : bean.getTypes()) {
            if (!(type instanceof Class) || !GraphDatabase.class.isAssignableFrom((Class)type)) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Discovered %s with qualifiers %s.", GraphDatabase.class.getName(), bean.getQualifiers()));
            }
            this.graphDatabases.put(new HashSet(bean.getQualifiers()), (Bean<GraphDatabase>)bean);
        }
    }

    void afterBeanDiscovery(@Observes AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager) {
        for (Map.Entry entry : this.getRepositoryTypes()) {
            Class repositoryType = (Class)entry.getKey();
            Set qualifiers = (Set)entry.getValue();
            CdiRepositoryBean repositoryBean = this.createRepositoryBean(repositoryType, qualifiers, beanManager);
            if (LOG.isInfoEnabled()) {
                LOG.info(String.format("Registering bean for %s with qualifiers %s.", repositoryType.getName(), qualifiers));
            }
            this.registerBean(repositoryBean);
            afterBeanDiscovery.addBean(repositoryBean);
        }
    }

    private <T> CdiRepositoryBean<T> createRepositoryBean(Class<T> repositoryType, Set<Annotation> qualifiers, BeanManager beanManager) {
        Bean<GraphDatabase> graphDatabase = this.graphDatabases.get(qualifiers);
        if (graphDatabase == null) {
            throw new UnsatisfiedResolutionException(String.format("Unable to resolve a bean for '%s' with qualifiers %s.", Neo4jMappingContext.class.getName(), qualifiers));
        }
        return new Neo4jCdiRepositoryBean<T>(graphDatabase, qualifiers, repositoryType, beanManager, this.getCustomImplementationDetector());
    }
}

