/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Map;
import org.neo4j.ogm.context.SingleUseEntityMapper;
import org.neo4j.ogm.metadata.MetaData;
import org.neo4j.ogm.metadata.reflect.EntityFactory;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.neo4j.annotation.QueryResult;
import org.springframework.data.neo4j.repository.query.QueryResultProxy;

class CustomResultConverter
implements Converter<Object, Object> {
    private final MetaData metaData;
    private final Class returnedType;

    CustomResultConverter(MetaData metaData, Class<?> returnedType) {
        this.metaData = metaData;
        this.returnedType = returnedType;
    }

    public Object convert(Object source) {
        if (this.returnedType.getAnnotation(QueryResult.class) == null) {
            return source;
        }
        SingleUseEntityMapper mapper = new SingleUseEntityMapper(this.metaData, new EntityFactory(this.metaData));
        if (this.returnedType.isInterface()) {
            Class[] interfaces = new Class[]{this.returnedType};
            return Proxy.newProxyInstance(this.returnedType.getClassLoader(), interfaces, (InvocationHandler)new QueryResultProxy((Map)source));
        }
        return mapper.map(this.returnedType, (Map)source);
    }
}

