/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.jspecify.annotations.Nullable;
import org.springframework.data.redis.core.RedisKeyspaceEvent;
import org.springframework.data.redis.core.convert.MappingRedisConverter;

public class RedisKeyExpiredEvent<T>
extends RedisKeyspaceEvent {
    private static final Charset CHARSET = StandardCharsets.UTF_8;
    private final @Nullable MappingRedisConverter.BinaryKeyspaceIdentifier objectId;
    private final @Nullable Object value;

    public RedisKeyExpiredEvent(byte[] key) {
        this(key, null);
    }

    public RedisKeyExpiredEvent(byte[] key, @Nullable Object value) {
        this(null, key, value);
    }

    public RedisKeyExpiredEvent(@Nullable String channel, byte[] key, @Nullable Object value) {
        super(channel, key);
        this.objectId = MappingRedisConverter.BinaryKeyspaceIdentifier.isValid(key) ? MappingRedisConverter.BinaryKeyspaceIdentifier.of(key) : null;
        this.value = value;
    }

    public @Nullable String getKeyspace() {
        return this.objectId != null ? new String(this.objectId.getKeyspace(), CHARSET) : null;
    }

    public byte[] getId() {
        return this.objectId != null ? this.objectId.getId() : this.getSource();
    }

    public @Nullable Object getValue() {
        return this.value;
    }

    public String toString() {
        byte[] id = this.getId();
        return "RedisKeyExpiredEvent [keyspace=" + this.getKeyspace() + ", id=" + (id == null ? null : new String(id)) + "]";
    }
}

