/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.sql;

import org.springframework.data.relational.core.sql.AbstractSegment;
import org.springframework.data.relational.core.sql.Condition;
import org.springframework.data.relational.core.sql.TableLike;

public class Join
extends AbstractSegment {
    private final JoinType type;
    private final TableLike joinTable;
    private final Condition on;

    Join(JoinType type, TableLike joinTable, Condition on) {
        super(joinTable, on);
        this.joinTable = joinTable;
        this.type = type;
        this.on = on;
    }

    public JoinType getType() {
        return this.type;
    }

    public TableLike getJoinTable() {
        return this.joinTable;
    }

    public Condition getOn() {
        return this.on;
    }

    @Override
    public String toString() {
        return (Object)((Object)this.type) + " " + this.joinTable + " ON " + this.on;
    }

    public static enum JoinType {
        JOIN("JOIN"),
        CROSS_JOIN("CROSS JOIN"),
        LEFT_OUTER_JOIN("LEFT OUTER JOIN"),
        RIGHT_OUTER_JOIN("RIGHT OUTER JOIN"),
        FULL_OUTER_JOIN("FULL OUTER JOIN");

        private final String sql;

        private JoinType(String sql) {
            this.sql = sql;
        }

        public String getSql() {
            return this.sql;
        }
    }
}

