/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.execution;

import io.micrometer.context.Nullable;
import java.util.Collection;
import org.reactivestreams.Publisher;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class ReactiveAdapterRegistryHelper {
    private static final ReactiveAdapterRegistry registry = ReactiveAdapterRegistry.getSharedInstance();

    public static <T> Mono<T> toMono(@Nullable Object result) {
        Mono mono;
        return (result = ReactiveAdapterRegistryHelper.toMonoIfReactive(result)) instanceof Mono ? (mono = (Mono)result) : Mono.justOrEmpty((Object)result);
    }

    @Nullable
    public static Object toMonoIfReactive(@Nullable Object result) {
        ReactiveAdapter adapter;
        ReactiveAdapter reactiveAdapter = adapter = result != null ? registry.getAdapter(result.getClass()) : null;
        if (adapter == null) {
            return result;
        }
        Publisher publisher = adapter.toPublisher(result);
        return adapter.isMultiValue() ? Flux.from((Publisher)publisher).collectList() : Mono.from((Publisher)publisher);
    }

    @Nullable
    public static Object toMonoOrFluxIfReactive(@Nullable Object result) {
        ReactiveAdapter adapter;
        ReactiveAdapter reactiveAdapter = adapter = result != null ? registry.getAdapter(result.getClass()) : null;
        if (adapter == null) {
            return result;
        }
        Publisher publisher = adapter.toPublisher(result);
        return adapter.isMultiValue() ? Flux.from((Publisher)publisher) : Mono.from((Publisher)publisher);
    }

    public static Flux<?> toSubscriptionFlux(@Nullable Object result) {
        if (result == null) {
            return Flux.empty();
        }
        if (result instanceof Publisher) {
            Publisher publisher = (Publisher)result;
            return Flux.from((Publisher)publisher);
        }
        ReactiveAdapter adapter = registry.getAdapter(result.getClass());
        Assert.state((adapter != null ? 1 : 0) != 0, (String)"Expected Publisher for a subscription");
        return Flux.from((Publisher)adapter.toPublisher(result));
    }

    public static <T> Flux<T> toFluxFromCollection(@Nullable Object result) {
        ReactiveAdapter adapter;
        if (result instanceof Collection) {
            return Flux.fromIterable((Iterable)((Collection)result));
        }
        ReactiveAdapter reactiveAdapter = adapter = result != null ? registry.getAdapter(result.getClass()) : null;
        if (adapter == null) {
            return Flux.error((Throwable)new IllegalStateException("Unexpected return value: " + result));
        }
        Publisher publisher = adapter.toPublisher(result);
        if (adapter.isMultiValue()) {
            return Flux.from((Publisher)publisher);
        }
        return Mono.from((Publisher)publisher).flatMapMany(c -> Flux.fromIterable((Iterable)((Collection)c)));
    }
}

