/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.listener;

import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.LogFactory;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.common.TopicPartition;
import org.springframework.core.log.LogAccessor;
import org.springframework.kafka.listener.DeliveryAttemptAware;
import org.springframework.kafka.listener.MessageListenerContainer;
import org.springframework.kafka.support.KafkaUtils;
import org.springframework.kafka.support.TopicPartitionOffset;

public interface CommonErrorHandler
extends DeliveryAttemptAware {
    default public boolean seeksAfterHandling() {
        return false;
    }

    default public boolean deliveryAttemptHeader() {
        return false;
    }

    default public void handleOtherException(Exception thrownException, Consumer<?, ?> consumer, MessageListenerContainer container, boolean batchListener) {
        this.logger().error((Throwable)thrownException, (CharSequence)"'handleOtherException' is not implemented by this handler");
    }

    default public boolean handleOne(Exception thrownException, ConsumerRecord<?, ?> record, Consumer<?, ?> consumer, MessageListenerContainer container) {
        this.logger().error((Throwable)thrownException, () -> "'handleOne' is not implemented by this handler for " + KafkaUtils.format(record));
        return true;
    }

    default public void handleRemaining(Exception thrownException, List<ConsumerRecord<?, ?>> records, Consumer<?, ?> consumer, MessageListenerContainer container) {
        this.logger().error((Throwable)thrownException, (CharSequence)"'handleRemaining' is not implemented by this handler");
    }

    default public void handleBatch(Exception thrownException, ConsumerRecords<?, ?> data, Consumer<?, ?> consumer, MessageListenerContainer container, Runnable invokeListener) {
        this.logger().error((Throwable)thrownException, (CharSequence)"'handleBatch' is not implemented by this handler");
    }

    default public LogAccessor logger() {
        return new LogAccessor(LogFactory.getLog(this.getClass()));
    }

    default public <K, V> ConsumerRecords<K, V> handleBatchAndReturnRemaining(Exception thrownException, ConsumerRecords<?, ?> data, Consumer<?, ?> consumer, MessageListenerContainer container, Runnable invokeListener) {
        this.handleBatch(thrownException, data, consumer, container, invokeListener);
        return ConsumerRecords.empty();
    }

    @Override
    default public int deliveryAttempt(TopicPartitionOffset topicPartitionOffset) {
        return 0;
    }

    default public void clearThreadState() {
    }

    default public boolean isAckAfterHandle() {
        return true;
    }

    default public void setAckAfterHandle(boolean ack) {
        throw new UnsupportedOperationException("This error handler does not support setting this property");
    }

    default public void onPartitionsAssigned(Consumer<?, ?> consumer, Collection<TopicPartition> partitions, Runnable publishPause) {
    }
}

